/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab.model;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.mi.tab.model.InteractionType;
import psidev.psi.mi.tab.model.InteractionTypeImpl;
import psidev.psi.mi.tab.model.UnmodifiableInteractionType;
import psidev.psi.mi.tab.model.isCache;

public class InteractionTypeFactory
implements isCache {
    public static final Log log = LogFactory.getLog(InteractionTypeFactory.class);
    private static InteractionTypeFactory ourInstance = new InteractionTypeFactory();
    private boolean cacheEnabled = false;
    final Map<String, InteractionType> cache = new HashMap<String, InteractionType>();

    public static InteractionTypeFactory getInstance() {
        return ourInstance;
    }

    private InteractionTypeFactory() {
    }

    public InteractionType build() {
        return new InteractionTypeImpl();
    }

    public InteractionType build(String database, String identifier) {
        if (database == null) {
            throw new IllegalArgumentException("You must give a non null database");
        }
        database = database.trim();
        if (identifier == null) {
            throw new IllegalArgumentException("You must give a non null identifier");
        }
        identifier = identifier.trim();
        InteractionType it = null;
        if (this.cacheEnabled) {
            String key = database + identifier;
            it = this.cache.get(key);
            if (it == null) {
                it = new UnmodifiableInteractionType(new InteractionTypeImpl(database, identifier));
                this.cache.put(key, it);
            }
        } else {
            it = new InteractionTypeImpl(database, identifier);
        }
        return it;
    }

    public InteractionType build(String database, String identifier, String text) {
        if (database == null) {
            throw new IllegalArgumentException("You must give a non null database");
        }
        database = database.trim();
        if (identifier == null) {
            throw new IllegalArgumentException("You must give a non null identifier");
        }
        identifier = identifier.trim();
        if (text == null || text.trim().length() == 0) {
            return this.build(database, identifier);
        }
        text = text.trim();
        InteractionType it = null;
        if (this.cacheEnabled) {
            String key = database + identifier + text;
            it = this.cache.get(key);
            if (it == null) {
                it = new UnmodifiableInteractionType(new InteractionTypeImpl(database, identifier, text));
                this.cache.put(key, it);
            }
        } else {
            it = new InteractionTypeImpl(database, identifier, text);
        }
        return it;
    }

    public void resetCache() {
        this.cache.clear();
    }

    public boolean isCacheEnabled() {
        return this.cacheEnabled;
    }

    public void setCacheEnabled(boolean enabled) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting InteractionTypes pooling: " + (enabled ? "on" : "off")));
        }
        this.cacheEnabled = enabled;
    }
}

