/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab.model;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.mi.tab.model.InteractionDetectionMethod;
import psidev.psi.mi.tab.model.InteractionDetectionMethodImpl;
import psidev.psi.mi.tab.model.UnmodifiableInteractionDetectionMethod;
import psidev.psi.mi.tab.model.isCache;

public class InteractionDetectionMethodFactory
implements isCache {
    public static final Log log = LogFactory.getLog(InteractionDetectionMethodFactory.class);
    private static InteractionDetectionMethodFactory ourInstance = new InteractionDetectionMethodFactory();
    private boolean cacheEnabled = false;
    final Map<String, InteractionDetectionMethod> cache = new HashMap<String, InteractionDetectionMethod>();

    public static InteractionDetectionMethodFactory getInstance() {
        return ourInstance;
    }

    private InteractionDetectionMethodFactory() {
    }

    public InteractionDetectionMethod build() {
        return new InteractionDetectionMethodImpl();
    }

    public InteractionDetectionMethod build(String database, String identifier) {
        if (database == null) {
            throw new IllegalArgumentException("You must give a non null database");
        }
        database = database.trim();
        if (identifier == null) {
            throw new IllegalArgumentException("You must give a non null identifier");
        }
        identifier = identifier.trim();
        InteractionDetectionMethod idm = null;
        if (this.cacheEnabled) {
            String key = database + identifier;
            idm = this.cache.get(key);
            if (idm == null) {
                idm = new UnmodifiableInteractionDetectionMethod(new InteractionDetectionMethodImpl(database, identifier));
                this.cache.put(key, idm);
            }
        } else {
            idm = new InteractionDetectionMethodImpl(database, identifier);
        }
        return idm;
    }

    public InteractionDetectionMethod build(String database, String identifier, String text) {
        if (database == null) {
            throw new IllegalArgumentException("You must give a non null database");
        }
        database = database.trim();
        if (identifier == null) {
            throw new IllegalArgumentException("You must give a non null identifier");
        }
        identifier = identifier.trim();
        if (text == null || text.trim().length() == 0) {
            return this.build(database, identifier);
        }
        text = text.trim();
        InteractionDetectionMethod it = null;
        if (this.cacheEnabled) {
            String key = database + identifier + text;
            it = this.cache.get(key);
            if (it == null) {
                it = new UnmodifiableInteractionDetectionMethod(new InteractionDetectionMethodImpl(database, identifier, text));
                this.cache.put(key, it);
            }
        } else {
            it = new InteractionDetectionMethodImpl(database, identifier, text);
        }
        return it;
    }

    public void resetCache() {
        this.cache.clear();
    }

    public boolean isCacheEnabled() {
        return this.cacheEnabled;
    }

    public void setCacheEnabled(boolean enabled) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting InteractionDetectionMethod pooling: " + (enabled ? "on" : "off")));
        }
        this.cacheEnabled = enabled;
    }
}

