/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab.model;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.mi.tab.model.CrossReference;
import psidev.psi.mi.tab.model.CrossReferenceImpl;
import psidev.psi.mi.tab.model.UnmodifiableCrossReference;
import psidev.psi.mi.tab.model.isCache;

public class CrossReferenceFactory
implements isCache {
    public static final Log log = LogFactory.getLog(CrossReferenceFactory.class);
    private static CrossReferenceFactory ourInstance = new CrossReferenceFactory();
    private boolean cacheEnabled = false;
    final Map<String, CrossReference> cache = new HashMap<String, CrossReference>();

    public static CrossReferenceFactory getInstance() {
        return ourInstance;
    }

    private CrossReferenceFactory() {
    }

    public CrossReference build() {
        return new CrossReferenceImpl();
    }

    public CrossReference build(String database, String identifier) {
        if (database == null) {
            throw new IllegalArgumentException("You must give a non null database");
        }
        database = database.trim();
        if (identifier == null) {
            throw new IllegalArgumentException("You must give a non null identifier");
        }
        if ((identifier = identifier.trim()).length() == 0) {
            throw new IllegalArgumentException("You must give a non empty identifier for database: " + database);
        }
        CrossReference cr = null;
        if (this.cacheEnabled) {
            String key = database + identifier;
            cr = this.cache.get(key);
            if (cr == null) {
                cr = new UnmodifiableCrossReference(new CrossReferenceImpl(database, identifier));
                this.cache.put(key, cr);
            }
        } else {
            cr = new CrossReferenceImpl(database, identifier);
        }
        return cr;
    }

    public CrossReference build(String database, String identifier, String text) {
        if (database == null) {
            throw new IllegalArgumentException("You must give a non null database");
        }
        database = database.trim();
        if (identifier == null) {
            throw new IllegalArgumentException("You must give a non null identifier");
        }
        identifier = identifier.trim();
        if (text == null || text.trim().length() == 0) {
            return this.build(database, identifier);
        }
        text = text.trim();
        CrossReference cr = null;
        if (this.cacheEnabled) {
            String key = database + identifier + text;
            cr = this.cache.get(key);
            if (cr == null) {
                cr = new UnmodifiableCrossReference(new CrossReferenceImpl(database, identifier, text));
                this.cache.put(key, cr);
            }
        } else {
            cr = new CrossReferenceImpl(database, identifier, text);
        }
        return cr;
    }

    public void resetCache() {
        this.cache.clear();
    }

    public boolean isCacheEnabled() {
        return this.cacheEnabled;
    }

    public void setCacheEnabled(boolean enabled) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting CrossReference pooling: " + (enabled ? "on" : "off")));
        }
        this.cacheEnabled = enabled;
    }
}

