/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab.expansion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.mi.tab.expansion.SpokeExpansion;
import psidev.psi.mi.xml.model.Interaction;
import psidev.psi.mi.xml.model.Interactor;
import psidev.psi.mi.xml.model.Participant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpokeWithoutBaitExpansion
extends SpokeExpansion {
    public static final String BAIT_MI_REF = "MI:0496";
    public static final Log log = LogFactory.getLog(SpokeWithoutBaitExpansion.class);

    @Override
    protected Collection<Interaction> processNoBaitExpansion(Interaction interaction) {
        ArrayList<Interaction> interactions = new ArrayList<Interaction>();
        log.debug((Object)"Could not find a bait participant. Pick a participant arbitrarily: 1st by alphabetical order.");
        if (interaction.getParticipants().isEmpty()) {
            return interactions;
        }
        List<Participant> sortedParticipants = this.sortParticipants(interaction.getParticipants());
        Participant fakeBait = sortedParticipants.get(0);
        for (int i = 1; i < sortedParticipants.size(); ++i) {
            Participant fakePrey = sortedParticipants.get(i);
            if (log.isDebugEnabled()) {
                String baitStr = this.displayParticipant(fakeBait);
                String preyStr = this.displayParticipant(fakePrey);
                log.debug((Object)("Build new binary interaction [" + baitStr + "," + preyStr + "]"));
            }
            Interaction spokeInteraction = this.buildInteraction(interaction, fakeBait, fakePrey);
            interactions.add(spokeInteraction);
        }
        return interactions;
    }

    protected List<Participant> sortParticipants(Collection<Participant> participants) {
        ArrayList<Participant> sortedParticipants = new ArrayList<Participant>(participants);
        Collections.sort(sortedParticipants, new Comparator<Participant>(){

            @Override
            public int compare(Participant p1, Participant p2) {
                Interactor i1 = p1.getInteractor();
                if (i1 == null) {
                    throw new IllegalArgumentException("Both participant should hold a valid interactor.");
                }
                Interactor i2 = p2.getInteractor();
                if (i2 == null) {
                    throw new IllegalArgumentException("Both participant should hold a valid interactor.");
                }
                String name1 = SpokeWithoutBaitExpansion.this.getName(i1);
                String name2 = SpokeWithoutBaitExpansion.this.getName(i2);
                int result = name1 == null ? -1 : (name2 == null ? 1 : name1.compareTo(name2));
                return result;
            }
        });
        return sortedParticipants;
    }

    private String getName(Interactor interactor) {
        if (interactor.getNames() != null && interactor.getNames().hasShortLabel()) {
            return interactor.getNames().getShortLabel();
        }
        return null;
    }
}

