/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab.expansion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.mi.tab.converter.xml2tab.XrefUtils;
import psidev.psi.mi.tab.expansion.BinaryExpansionStrategy;
import psidev.psi.mi.xml.model.ExperimentalRole;
import psidev.psi.mi.xml.model.Interaction;
import psidev.psi.mi.xml.model.Participant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpokeExpansion
extends BinaryExpansionStrategy {
    public static final String EXPANSION_NAME = "Spoke";
    public static final String BAIT_MI_REF = "MI:0496";
    public static final Log log = LogFactory.getLog(SpokeExpansion.class);

    @Override
    public Collection<Interaction> expand(Interaction interaction) {
        ArrayList<Interaction> interactions = new ArrayList<Interaction>();
        if (interaction.getParticipants().isEmpty()) {
            return interactions;
        }
        if (this.isBinary(interaction)) {
            log.debug((Object)("interaction " + interaction.getId() + "/" + interaction.getImexId() + " was binary, no further processing involved."));
            interactions.add(interaction);
        } else {
            Collection<Participant> participants = interaction.getParticipants();
            log.debug((Object)(participants.size() + " participant(s) found."));
            Participant bait = this.searchBaitParticipant(participants);
            if (bait != null) {
                ArrayList<Participant> preys = new ArrayList<Participant>(participants.size() - 1);
                preys.addAll(participants);
                preys.remove(bait);
                for (Participant prey : preys) {
                    if (log.isDebugEnabled()) {
                        String baitStr = this.displayParticipant(bait);
                        String preyStr = this.displayParticipant(prey);
                        log.debug((Object)("Build new binary interaction [" + baitStr + "," + preyStr + "]"));
                    }
                    Interaction i = this.buildInteraction(interaction, bait, prey);
                    interactions.add(i);
                }
            } else {
                Collection<Interaction> noBaitExpandedInteractions = this.processNoBaitExpansion(interaction);
                interactions.addAll(noBaitExpandedInteractions);
            }
            log.debug((Object)("After expansion: " + interactions.size() + " binary interaction(s) were generated."));
        }
        return interactions;
    }

    protected Collection<Interaction> processNoBaitExpansion(Interaction interaction) {
        log.debug((Object)"Could not find a bait participant. No further processing involved.");
        return Collections.EMPTY_LIST;
    }

    protected String displayParticipant(Participant p) {
        String role = "";
        for (ExperimentalRole aRole : p.getExperimentalRoles()) {
            if (role.length() > 0) {
                role = role + "&";
            }
            if (aRole.hasNames()) {
                role = role + aRole.getNames().getShortLabel();
                continue;
            }
            role = role + "?";
        }
        String interactor = p.getInteractor().getNames().getShortLabel();
        return interactor + ":" + role;
    }

    protected boolean isBait(Participant participant) {
        if (participant == null) {
            throw new IllegalArgumentException("Participant must not be null.");
        }
        if (participant.hasExperimentalRoles()) {
            for (ExperimentalRole role : participant.getExperimentalRoles()) {
                log.debug((Object)("Checking if participant (id:" + participant.getId() + ") is a bait."));
                if (XrefUtils.hasPsiId(role.getXref(), BAIT_MI_REF)) {
                    log.debug((Object)"Yes it is.");
                    return true;
                }
                log.debug((Object)"No it is not.");
            }
        }
        return false;
    }

    protected Participant searchBaitParticipant(Collection<Participant> participants) {
        if (participants == null) {
            throw new IllegalArgumentException("Participants must not be null.");
        }
        for (Participant participant : participants) {
            if (!this.isBait(participant)) continue;
            return participant;
        }
        return null;
    }

    @Override
    public String getName() {
        return EXPANSION_NAME;
    }
}

