/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab.converter.xml2tab;

import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.mi.tab.converter.tab2xml.XmlConversionException;
import psidev.psi.mi.tab.converter.xml2tab.TabConversionException;
import psidev.psi.mi.tab.converter.xml2tab.XrefUtils;
import psidev.psi.mi.tab.model.CrossReferenceImpl;
import psidev.psi.mi.xml.model.CvType;
import psidev.psi.mi.xml.model.DbReference;
import psidev.psi.mi.xml.model.Names;
import psidev.psi.mi.xml.model.Xref;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CvConverter {
    public static final Log log = LogFactory.getLog(CvConverter.class);
    public static final String PSI_MI = "psi-mi";
    public static final String PSI_MI_REF = "MI:0488";

    public <CV extends CrossReferenceImpl> CV toMitab(CvType cv, Class<CV> clazz) throws TabConversionException {
        Collection<DbReference> refs;
        CrossReferenceImpl myCv = null;
        if (cv == null) {
            throw new IllegalArgumentException("You must give a non null JAXB OpenCvType.");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("You must give a non null implementation class of CrossReference");
        }
        String name = null;
        String db = "unknown";
        String id = null;
        if (cv.hasNames()) {
            name = cv.getNames().getShortLabel();
        }
        if ((refs = XrefUtils.searchByDatabase(cv.getXref(), PSI_MI, PSI_MI_REF)).isEmpty()) {
            refs = XrefUtils.searchByType(cv.getXref(), "identity", "MI:0356");
        }
        if (!refs.isEmpty()) {
            db = PSI_MI;
            Iterator<DbReference> iterator = refs.iterator();
            id = iterator.next().getId();
            if (iterator.hasNext()) {
                log.warn((Object)(cv + " has " + refs.size() + " references to PSI-MI to choose from, picked the first one."));
                log.warn((Object)("1: " + id));
                int i = 1;
                while (iterator.hasNext()) {
                    DbReference dbReference = iterator.next();
                    log.warn((Object)(++i + ": " + dbReference.getId()));
                }
            }
        }
        if (name != null) {
            try {
                Constructor<CV> constructor = clazz.getConstructor(String.class, String.class);
                myCv = (CrossReferenceImpl)constructor.newInstance(db, id);
                myCv.setText(name);
            }
            catch (Exception e) {
                throw new TabConversionException("An exception was thrown while instanciating an model.CvType via reflection. Nested Exception attached", e);
            }
        }
        return (CV)myCv;
    }

    public <CV extends CrossReferenceImpl, T extends CvType> T fromMitab(CV tabCv, Class<T> clazz) throws XmlConversionException {
        CvType myCv = null;
        if (tabCv == null) {
            throw new IllegalArgumentException("You must give a non null tabCv CV.");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("You must give a non null implementation class of CV");
        }
        Names names = null;
        Xref xref = null;
        if (tabCv.hasText()) {
            String shortLabel = tabCv.getText();
            names = new Names();
            names.setShortLabel(shortLabel);
        }
        if (tabCv.getIdentifier() != null) {
            String id = "MI:".concat(tabCv.getIdentifier());
            DbReference primaryRef = new DbReference();
            primaryRef.setId(id);
            xref = new Xref(primaryRef);
        }
        try {
            Constructor<T> constructor = clazz.getConstructor(new Class[0]);
            myCv = (CvType)constructor.newInstance(new Object[0]);
            if (names != null) {
                myCv.setNames(names);
            }
            if (xref != null) {
                myCv.setXref(xref);
            }
        }
        catch (Exception e) {
            throw new XmlConversionException("An exception was thrown while instanciating an xml.", e);
        }
        return (T)myCv;
    }
}

