/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab.converter.tab2xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.mi.tab.converter.tab2xml.InteractorNameBuilder;
import psidev.psi.mi.tab.converter.tab2xml.XmlConversionException;
import psidev.psi.mi.tab.converter.xml2tab.InteractionConverter;
import psidev.psi.mi.tab.converter.xml2tab.InteractorConverter;
import psidev.psi.mi.tab.converter.xml2tab.MitabInteractionConverter;
import psidev.psi.mi.tab.converter.xml2tab.NullCrossReference;
import psidev.psi.mi.tab.model.BinaryInteraction;
import psidev.psi.mi.tab.model.CrossReference;
import psidev.psi.mi.tab.model.Interactor;
import psidev.psi.mi.xml.PsimiXmlVersion;
import psidev.psi.mi.xml.model.DbReference;
import psidev.psi.mi.xml.model.Entry;
import psidev.psi.mi.xml.model.EntrySet;
import psidev.psi.mi.xml.model.Interaction;
import psidev.psi.mi.xml.model.Names;
import psidev.psi.mi.xml.model.Participant;
import psidev.psi.mi.xml.model.Source;
import psidev.psi.mi.xml.model.Xref;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tab2Xml {
    public static final Log log = LogFactory.getLog(Tab2Xml.class);
    private InteractionConverter<?> interactionConverter;
    private Collection<Interaction> interactions;
    private Collection<psidev.psi.mi.xml.model.Interactor> interactors = new ArrayList<psidev.psi.mi.xml.model.Interactor>();
    private InteractorNameBuilder interactorNameBuilder;
    protected static final String IREFINDEX = "irefindex";

    public Tab2Xml() {
        this(new MitabInteractionConverter());
    }

    public Tab2Xml(InteractionConverter<?> interactionConverter) {
        this.interactionConverter = interactionConverter;
    }

    public EntrySet convert(Collection<BinaryInteraction> binaryInteractions) throws IllegalAccessException, XmlConversionException {
        return this.convert(binaryInteractions, this.createSource(null, null));
    }

    public EntrySet convert(Collection<BinaryInteraction> binaryInteractions, String dbMi, String dbName) throws IllegalAccessException, XmlConversionException {
        return this.convert(binaryInteractions, this.createSource(dbName, dbMi));
    }

    public EntrySet convert(Collection<BinaryInteraction> mitabInteractions, Source source) throws IllegalAccessException, XmlConversionException {
        if (mitabInteractions.isEmpty()) {
            throw new IllegalAccessException("No binary interactions found in the collection");
        }
        EntrySet entrySet = new EntrySet(PsimiXmlVersion.VERSION_25_UNDEFINED);
        Entry entry = new Entry();
        entry.setSource(source);
        this.interactions = new ArrayList<Interaction>();
        Map<String, Collection<Participant>> interactionMap = this.createInteractionMap(mitabInteractions);
        for (BinaryInteraction binaryInteraction : mitabInteractions) {
            this.interactions = this.interactionConverter.fromMitab(binaryInteraction, interactionMap);
            entry.getInteractions().addAll(this.interactions);
        }
        entrySet.getEntries().add(entry);
        return entrySet;
    }

    public InteractorNameBuilder getInteractorNameBuilder() {
        return this.interactorNameBuilder;
    }

    public void setInteractorNameBuilder(InteractorNameBuilder interactorNameBuilder) {
        this.interactorNameBuilder = interactorNameBuilder;
    }

    public Collection<Interaction> getInteractions() {
        return this.interactions;
    }

    public Collection<psidev.psi.mi.xml.model.Interactor> getInteractors() {
        return this.interactors;
    }

    protected Map<String, Collection<Participant>> createInteractionMap(Collection<BinaryInteraction> miTabInteractions) throws IllegalAccessException, XmlConversionException {
        InteractorConverter<?> interactorConverter = this.interactionConverter.getInteractorConverter();
        HashMap<String, Collection<Participant>> interactionMap = new HashMap<String, Collection<Participant>>();
        interactorConverter.setInteractorNameBuilder(this.getInteractorNameBuilder());
        for (BinaryInteraction binaryInteraction : miTabInteractions) {
            List<CrossReference> crossReference = binaryInteraction.getInteractionAcs();
            if (crossReference.isEmpty()) {
                crossReference.add(new NullCrossReference(binaryInteraction));
            }
            String interactionId = crossReference.get(0).getIdentifier();
            interactionId = interactionId + "_" + ((Interactor)binaryInteraction.getInteractorA()).getIdentifiers().iterator().next().getIdentifier() + "_" + ((Interactor)binaryInteraction.getInteractorB()).getIdentifiers().iterator().next().getIdentifier();
            psidev.psi.mi.xml.model.Interactor iA = interactorConverter.fromMitab((Interactor)binaryInteraction.getInteractorA());
            psidev.psi.mi.xml.model.Interactor iB = interactorConverter.fromMitab((Interactor)binaryInteraction.getInteractorB());
            iA = this.checkInteractor(iA);
            iB = this.checkInteractor(iB);
            Participant pA = interactorConverter.buildParticipantA(iA, binaryInteraction, 0);
            Participant pB = interactorConverter.buildParticipantB(iB, binaryInteraction, 0);
            Collection participants = null;
            participants = !interactionMap.containsKey(interactionId) ? new ArrayList() : (Collection)interactionMap.get(interactionId);
            if (!participants.contains(pA)) {
                participants.add(pA);
            }
            if (!participants.contains(pB)) {
                participants.add(pB);
            }
            interactionMap.put(interactionId, participants);
        }
        return interactionMap;
    }

    private psidev.psi.mi.xml.model.Interactor checkInteractor(psidev.psi.mi.xml.model.Interactor interactor1) {
        psidev.psi.mi.xml.model.Interactor interactor = interactor1;
        for (psidev.psi.mi.xml.model.Interactor interactor2 : this.interactors) {
            if (!interactor1.getNames().equals(interactor2.getNames()) || !interactor1.getXref().equals(interactor2.getXref())) continue;
            interactor = interactor2;
            break;
        }
        if (interactor.equals(interactor1) && !this.interactors.contains(interactor1)) {
            this.interactors.add(interactor);
        }
        return interactor;
    }

    private Source createSource(String db, String dbMi) {
        Source source = new Source();
        Date date = new Date();
        source.setReleaseDate(date);
        Names names = new Names();
        if (db != null) {
            names.setShortLabel(db);
        } else {
            names.setShortLabel("unspecified");
        }
        source.setNames(names);
        if (dbMi != null && dbMi.startsWith("MI:")) {
            DbReference dbReference = new DbReference("psi-mi", "MI:0488", dbMi, "primary-reference", "MI:0358");
            Xref xref = new Xref(dbReference);
            source.setXref(xref);
        }
        return source;
    }
}

