/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab.converter.tab2xml;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.mi.tab.converter.tab2xml.InteractorNameBuilder;
import psidev.psi.mi.tab.model.CrossReference;
import psidev.psi.mi.tab.model.Interactor;
import psidev.psi.mi.xml.model.Alias;
import psidev.psi.mi.xml.model.Names;

public class InteractorIdBuilder
implements InteractorNameBuilder {
    public static final Log log = LogFactory.getLog(InteractorIdBuilder.class);

    public Names select(Interactor interactor) {
        Names interactorName = null;
        if (interactor == null) {
            throw new IllegalArgumentException("You must give a non null Interactor.");
        }
        if (!interactor.getIdentifiers().isEmpty()) {
            String shortLabel = null;
            for (CrossReference identifier : interactor.getIdentifiers()) {
                if (!identifier.getDatabase().equals("uniprotkb")) continue;
                shortLabel = identifier.getIdentifier();
                break;
            }
            if (shortLabel != null) {
                interactorName = new Names();
                interactorName.setShortLabel(shortLabel);
            } else {
                log.debug((Object)("No valid uniprot interactorName found. default : 1.interactor identifier of db = " + interactor.getIdentifiers().iterator().next().getDatabase()));
                interactorName = new Names();
                interactorName.setShortLabel(interactor.getIdentifiers().iterator().next().getIdentifier());
            }
        }
        if (!interactor.getAliases().isEmpty() && interactorName != null) {
            ArrayList<Alias> aliases = new ArrayList<Alias>();
            for (psidev.psi.mi.tab.model.Alias tabAlias : interactor.getAliases()) {
                String type = tabAlias.getAliasType();
                String value = tabAlias.getName();
                Alias alias = new Alias();
                alias.setValue(value);
                alias.setType(type);
                aliases.add(alias);
            }
            if (!aliases.isEmpty()) {
                interactorName.getAliases().addAll(aliases);
            }
        }
        return interactorName;
    }
}

