/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import psidev.psi.mi.tab.PsimiTabIterator;
import psidev.psi.mi.tab.converter.txt2tab.MitabLineException;
import psidev.psi.mi.tab.converter.txt2tab.behaviour.UnparseableLineBehaviour;
import psidev.psi.mi.tab.model.BinaryInteraction;
import psidev.psi.mi.tab.model.CrossReferenceFactory;
import psidev.psi.mi.tab.model.InteractionDetectionMethodFactory;
import psidev.psi.mi.tab.model.InteractionTypeFactory;
import psidev.psi.mi.tab.model.OrganismFactory;
import psidev.psi.mi.tab.model.builder.DocumentDefinition;
import psidev.psi.mi.tab.model.builder.MitabDocumentDefinition;
import psidev.psi.mi.xml.converter.ConverterException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PsimiTabReader {
    private DocumentDefinition documentDefinition;
    private boolean hasHeaderLine = true;
    private Collection<BinaryInteraction> interactions;
    private UnparseableLineBehaviour unparseableLineBehaviour;

    public PsimiTabReader(boolean hasHeaderLine) {
        this(new MitabDocumentDefinition(), hasHeaderLine);
    }

    public PsimiTabReader(DocumentDefinition documentDefinition, boolean hasHeaderLine) {
        this.documentDefinition = documentDefinition;
        this.hasHeaderLine = hasHeaderLine;
    }

    public boolean isHasHeaderLine() {
        return this.hasHeaderLine;
    }

    public void setHasHeaderLine(boolean hasHeaderLine) {
        this.hasHeaderLine = hasHeaderLine;
    }

    public UnparseableLineBehaviour getUnparseableLineBehaviour() {
        return this.unparseableLineBehaviour;
    }

    public void setUnparseableLineBehaviour(UnparseableLineBehaviour unparseableLineBehaviour) {
        this.unparseableLineBehaviour = unparseableLineBehaviour;
    }

    public void setEnableObjectPooling(boolean enabled) {
        CrossReferenceFactory.getInstance().setCacheEnabled(enabled);
        InteractionTypeFactory.getInstance().setCacheEnabled(enabled);
        InteractionDetectionMethodFactory.getInstance().setCacheEnabled(enabled);
        OrganismFactory.getInstance().setCacheEnabled(enabled);
    }

    public Collection<BinaryInteraction> read(String s) throws IOException, ConverterException {
        return this.read(new ByteArrayInputStream(s.getBytes()));
    }

    public Iterator<BinaryInteraction> iterate(String s) throws IOException, ConverterException {
        ByteArrayInputStream is = new ByteArrayInputStream(s.getBytes());
        InputStreamReader reader = new InputStreamReader(is);
        return new PsimiTabIterator(this.documentDefinition, reader, this.hasHeaderLine);
    }

    public Collection<BinaryInteraction> read(File file) throws IOException, ConverterException {
        return this.read(new FileReader(file));
    }

    public Iterator<BinaryInteraction> iterate(File file) throws IOException, ConverterException {
        return new PsimiTabIterator(this.documentDefinition, new FileReader(file), this.hasHeaderLine);
    }

    public Collection<BinaryInteraction> read(InputStream is) throws IOException, ConverterException {
        return this.read(new InputStreamReader(is));
    }

    public Collection<BinaryInteraction> read(Reader reader) throws IOException, ConverterException {
        String line;
        this.interactions = new ArrayList<BinaryInteraction>();
        BufferedReader in = new BufferedReader(reader);
        int lineIndex = 1;
        if (this.hasHeaderLine) {
            String l = in.readLine();
            ++lineIndex;
        }
        while ((line = in.readLine()) != null) {
            try {
                Object interaction = this.documentDefinition.interactionFromString(line);
                this.processInteraction((BinaryInteraction)interaction);
                ++lineIndex;
            }
            catch (Throwable e) {
                in.close();
                throw new ConverterException("Exception parsing line " + lineIndex + ": " + line, e);
            }
        }
        in.close();
        return this.interactions;
    }

    public Iterator<BinaryInteraction> iterate(InputStream is) throws IOException, ConverterException {
        return new PsimiTabIterator(this.documentDefinition, new InputStreamReader(is), this.hasHeaderLine);
    }

    public Iterator<BinaryInteraction> iterate(Reader r) throws IOException, ConverterException {
        return new PsimiTabIterator(this.documentDefinition, r, this.hasHeaderLine);
    }

    public Collection<BinaryInteraction> read(URL url) throws IOException, ConverterException {
        return this.read(url.openStream());
    }

    public BinaryInteraction readLine(String str) {
        return this.documentDefinition.interactionFromString(str);
    }

    protected void processInteraction(BinaryInteraction interaction) throws MitabLineException {
        this.interactions.add(interaction);
    }
}

