/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.work.internal.tunables.utils;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.text.DecimalFormat;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class TunableBoundedField
extends JTextField {
    private static final long serialVersionUID = -3420958244665421522L;
    private final Number initVal;
    private Number defaultValue;
    private final Number min;
    private final Number max;
    private DecimalFormat df = new DecimalFormat("##.##");

    public TunableBoundedField(Number initVal, Number min, Number max, Boolean lower, Boolean upper) {
        this.initVal = initVal;
        this.min = min;
        this.max = max;
        this.defaultValue = initVal;
        this.setInitValue();
        this.initUI();
    }

    protected void initUI() {
        this.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Number val = TunableBoundedField.this.getFieldValue();
                if (!val.equals(TunableBoundedField.this.defaultValue)) {
                    TunableBoundedField.this.defaultValue = val;
                }
                TunableBoundedField.this.setFieldValue();
            }
        });
        this.setHorizontalAlignment(4);
    }

    private void setFieldValue() {
        this.setText(this.defaultValue.toString());
    }

    private void setInitValue() {
        this.setText(this.initVal.toString());
    }

    public Number getFieldValue() {
        if (this.defaultValue instanceof Double) {
            return this.getDoubleFieldValue();
        }
        if (this.defaultValue instanceof Float) {
            return this.getFloatFieldValue();
        }
        if (this.defaultValue instanceof Integer) {
            return this.getIntegerFieldValue();
        }
        if (this.defaultValue instanceof Long) {
            return this.getLongFieldValue();
        }
        throw new IllegalStateException("unexpected type: " + this.defaultValue.getClass() + ".");
    }

    private Double getDoubleFieldValue() {
        Double val = null;
        try {
            val = Double.parseDouble(this.getText());
        }
        catch (NumberFormatException nfe) {
            this.setBackground(Color.RED);
            JOptionPane.showMessageDialog(null, "Please enter a double", "Alert", 0);
            this.setFieldValue();
            this.setBackground(UIManager.getColor("TextField.background"));
            try {
                val = (Double)this.defaultValue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (val < (Double)this.min) {
            this.setBackground(Color.RED);
            JOptionPane.showMessageDialog(null, "Value (" + val + ") is less than lower limit (" + this.df.format(this.min.doubleValue()) + ")\nValue will be set to default : " + this.defaultValue, "Alert", 0);
            this.setInitValue();
            this.setFieldValue();
            this.setBackground(UIManager.getColor("TextField.background"));
            return (Double)this.defaultValue;
        }
        if (val > (Double)this.max) {
            this.setBackground(Color.RED);
            JOptionPane.showMessageDialog(null, "Value (" + val + ") is larger than upper limit (" + this.df.format(this.max.doubleValue()) + ")\nValue will be set to default : " + this.defaultValue, "Alert", 0);
            this.setInitValue();
            this.setFieldValue();
            this.setBackground(UIManager.getColor("TextField.background"));
            return (Double)this.defaultValue;
        }
        return val;
    }

    private Float getFloatFieldValue() {
        Float val = null;
        try {
            val = Float.valueOf(Float.parseFloat(this.getText()));
        }
        catch (NumberFormatException nfe) {
            this.setBackground(Color.RED);
            JOptionPane.showMessageDialog(null, "Please enter a float", "Alert", 0);
            this.setFieldValue();
            this.setBackground(UIManager.getColor("TextField.background"));
            try {
                val = (Float)this.defaultValue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (val.floatValue() < ((Float)this.min).floatValue()) {
            this.setBackground(Color.RED);
            JOptionPane.showMessageDialog(null, "Value (" + val.floatValue() + ") is less than lower limit (" + this.df.format(this.min.floatValue()) + ")\nValue will be set to default : " + this.defaultValue, "Alert", 0);
            this.setInitValue();
            this.setFieldValue();
            this.setBackground(UIManager.getColor("TextField.background"));
            return (Float)this.defaultValue;
        }
        if (val.floatValue() > ((Float)this.max).floatValue()) {
            this.setBackground(Color.RED);
            JOptionPane.showMessageDialog(null, "Value (" + val.floatValue() + ") is larger than upper limit (" + this.df.format(this.max.floatValue()) + ")\nValue will be set to default : " + this.defaultValue, "Alert", 0);
            this.setInitValue();
            this.setFieldValue();
            this.setBackground(UIManager.getColor("TextField.background"));
            return (Float)this.defaultValue;
        }
        return val;
    }

    private Integer getIntegerFieldValue() {
        Integer val = null;
        try {
            val = Integer.parseInt(this.getText());
        }
        catch (NumberFormatException nfe) {
            this.setBackground(Color.RED);
            JOptionPane.showMessageDialog(null, "Please enter an integer", "Alert", 0);
            this.setFieldValue();
            this.setBackground(UIManager.getColor("TextField.background"));
            try {
                val = (Integer)this.defaultValue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (val < (Integer)this.min) {
            this.setBackground(Color.RED);
            JOptionPane.showMessageDialog(null, "Value (" + val + ") is less than lower limit (" + this.df.format(this.min.intValue()) + ")\nValue will be set to default : " + this.defaultValue, "Alert", 0);
            this.setInitValue();
            this.setFieldValue();
            this.setBackground(UIManager.getColor("TextField.background"));
            return (Integer)this.defaultValue;
        }
        if (val > (Integer)this.max) {
            this.setBackground(Color.RED);
            JOptionPane.showMessageDialog(null, "Value (" + val + ") is larger than upper limit (" + this.df.format(this.max.intValue()) + ")\nValue will be set to default : " + this.defaultValue, "Alert", 0);
            this.setInitValue();
            this.setFieldValue();
            this.setBackground(UIManager.getColor("TextField.background"));
            return (Integer)this.defaultValue;
        }
        return val;
    }

    private Long getLongFieldValue() {
        Long val = null;
        try {
            val = Long.parseLong(this.getText());
        }
        catch (NumberFormatException nfe) {
            this.setBackground(Color.RED);
            JOptionPane.showMessageDialog(null, "Please enter a large integer (\"long\")", "Alert", 0);
            this.setFieldValue();
            this.setBackground(UIManager.getColor("TextField.background"));
            try {
                val = (Long)this.defaultValue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (val < (Long)this.min) {
            this.setBackground(Color.RED);
            JOptionPane.showMessageDialog(null, "Value (" + val + ") is less than lower limit (" + this.df.format(this.min.longValue()) + ")\nValue will be set to default : " + this.defaultValue, "Alert", 0);
            this.setInitValue();
            this.setFieldValue();
            this.setBackground(UIManager.getColor("TextField.background"));
            return (Long)this.defaultValue;
        }
        if (val > (Long)this.max) {
            this.setBackground(Color.RED);
            JOptionPane.showMessageDialog(null, "Value (" + val + ") is larger than upper limit (" + this.df.format(this.max.longValue()) + ")\nValue will be set to default : " + this.defaultValue, "Alert", 0);
            this.setInitValue();
            this.setFieldValue();
            this.setBackground(UIManager.getColor("TextField.background"));
            return (Long)this.defaultValue;
        }
        return val;
    }
}

