/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.work.internal.tunables.utils;

import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.work.FinishStatus;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.swing.AbstractGUITunableHandler;

public final class GUIDefaults {
    public static final String ICON_INFO = "\uf05a";
    public static final String ICON_WARN = "\uf071";
    public static final String ICON_ERROR = "\uf056";
    public static final String ICON_CANCELLED = "\uf05e";
    public static final String ICON_FINISHED = "\uf00c";
    public static final int TEXT_BOX_WIDTH = 150;

    public static TaskIcon getIcon(TaskMonitor.Level level) {
        if (level == null) {
            return null;
        }
        switch (level) {
            case INFO: {
                return TaskIcon.INFO;
            }
            case WARN: {
                return TaskIcon.WARN;
            }
            case ERROR: {
                return TaskIcon.ERROR;
            }
        }
        return null;
    }

    public static TaskIcon getIcon(FinishStatus.Type type) {
        if (type == null) {
            return null;
        }
        switch (type) {
            case SUCCEEDED: {
                return TaskIcon.FINISHED;
            }
            case FAILED: {
                return TaskIcon.ERROR;
            }
            case CANCELLED: {
                return TaskIcon.CANCELLED;
            }
        }
        return null;
    }

    public static String getIconText(TaskMonitor.Level level) {
        if (level == null) {
            return null;
        }
        switch (level) {
            case INFO: {
                return ICON_INFO;
            }
            case WARN: {
                return ICON_WARN;
            }
            case ERROR: {
                return ICON_ERROR;
            }
        }
        return null;
    }

    public static Color getForeground(TaskMonitor.Level level) {
        if (level == null) {
            return null;
        }
        switch (level) {
            case INFO: {
                return LookAndFeelUtil.getInfoColor();
            }
            case WARN: {
                return LookAndFeelUtil.getWarnColor();
            }
            case ERROR: {
                return LookAndFeelUtil.getErrorColor();
            }
        }
        return null;
    }

    public static Color getForeground(String iconText) {
        TaskIcon icon = TaskIcon.toIcon(iconText);
        return icon != null ? icon.getForeground() : UIManager.getColor("Label.foreground");
    }

    public static void updateFieldPanel(JPanel p, Component control, boolean horizontalForm) {
        GUIDefaults.updateFieldPanel(p, new JLabel(" "), control, horizontalForm);
    }

    public static void updateFieldPanel(JPanel p, JLabel label, Component control, boolean horizontalForm) {
        if (label == null) {
            label = new JLabel(" ");
        }
        if (horizontalForm) {
            label.setHorizontalAlignment(2);
        } else {
            label.setHorizontalAlignment(4);
        }
        GUIDefaults.updateFieldPanel(p, (Component)label, control, horizontalForm);
    }

    public static void updateFieldPanel(JPanel p, JTextArea textArea, Component control, boolean horizontalForm) {
        if (textArea != null) {
            textArea.setLineWrap(true);
            textArea.setWrapStyleWord(true);
            textArea.setOpaque(false);
            textArea.setBorder(null);
            textArea.setEditable(false);
            GUIDefaults.updateFieldPanel(p, (Component)textArea, control, horizontalForm);
        } else {
            GUIDefaults.updateFieldPanel(p, new JLabel(" "), control, horizontalForm);
        }
    }

    public static void setTooltip(String text, JComponent ... components) {
        if (text == null) {
            return;
        }
        if ((text = text.trim()).isEmpty()) {
            return;
        }
        ToolTipManager tipManager = ToolTipManager.sharedInstance();
        tipManager.setInitialDelay(1);
        tipManager.setDismissDelay(7500);
        for (JComponent c : components) {
            if (c == null) continue;
            c.setToolTipText(text);
        }
    }

    private static void updateFieldPanel(JPanel p, Component label, Component control, boolean horizontalForm) {
        GroupLayout.Alignment vAlign;
        if (p instanceof AbstractGUITunableHandler.TunableFieldPanel) {
            ((AbstractGUITunableHandler.TunableFieldPanel)p).setControl(control);
            if (label instanceof JLabel) {
                ((AbstractGUITunableHandler.TunableFieldPanel)p).setLabel((JLabel)label);
            } else if (label instanceof JTextArea) {
                ((AbstractGUITunableHandler.TunableFieldPanel)p).setMultiLineLabel((JTextArea)label);
            }
            return;
        }
        p.removeAll();
        GroupLayout layout = new GroupLayout(p);
        p.setLayout(layout);
        layout.setAutoCreateContainerGaps(false);
        layout.setAutoCreateGaps(true);
        GroupLayout.Alignment alignment = vAlign = control instanceof JPanel || control instanceof JScrollPane ? GroupLayout.Alignment.LEADING : GroupLayout.Alignment.CENTER;
        if (horizontalForm) {
            p.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
            layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(label, -2, -1, -2).addComponent(control, -2, -1, -2));
            layout.setVerticalGroup(layout.createParallelGroup(vAlign, false).addComponent(label).addComponent(control));
        } else {
            p.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
            int w = Math.max(label.getPreferredSize().width, control.getPreferredSize().width);
            int gap = w - control.getPreferredSize().width;
            layout.setHorizontalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, true).addComponent(label, w, w, Short.MAX_VALUE)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addGroup(layout.createSequentialGroup().addComponent(control, -2, -1, -2).addGap(gap, gap, Short.MAX_VALUE))));
            layout.setVerticalGroup(layout.createParallelGroup(vAlign, false).addComponent(label).addComponent(control));
        }
    }

    private GUIDefaults() {
    }

    public static enum TaskIcon {
        INFO("\uf05a"),
        WARN("\uf071"),
        ERROR("\uf056"),
        CANCELLED("\uf05e"),
        FINISHED("\uf00c"),
        TASKS("\uf0ca");

        private final String text;

        private TaskIcon(String text) {
            this.text = text;
        }

        public Color getForeground() {
            switch (this) {
                case INFO: {
                    return LookAndFeelUtil.getInfoColor();
                }
                case WARN: {
                    return LookAndFeelUtil.getWarnColor();
                }
                case ERROR: {
                    return LookAndFeelUtil.getErrorColor();
                }
                case CANCELLED: {
                    return LookAndFeelUtil.getErrorColor();
                }
                case FINISHED: {
                    return LookAndFeelUtil.getSuccessColor();
                }
            }
            return UIManager.getColor("Label.foreground");
        }

        public String getText() {
            return this.text;
        }

        public static TaskIcon toIcon(String text) {
            for (TaskIcon icon : TaskIcon.values()) {
                if (!icon.getText().equals(text)) continue;
                return icon;
            }
            return null;
        }
    }
}

