/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.work.internal.tunables.utils;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.cytoscape.work.internal.tunables.utils.CheckListCellRenderer;
import org.cytoscape.work.util.ListMultipleSelection;

public class CheckListManager<T>
extends MouseAdapter
implements ActionListener,
ListSelectionListener {
    private ListSelectionModel selectionModel = new DefaultListSelectionModel();
    private JList list = new JList();
    ArrayList<T> arrayOut = new ArrayList();
    ArrayList<Integer> arrayTest = null;
    ListMultipleSelection<T> LMS;
    int hotspot;
    Map<Integer, T> map;
    int test;

    public CheckListManager(JList list, ListMultipleSelection<T> LMS) {
        this.hotspot = new JCheckBox().getPreferredSize().width;
        this.map = new HashMap<Integer, T>();
        this.LMS = LMS;
        this.list = list;
        list.setVisibleRowCount(4);
        list.setCellRenderer(new CheckListCellRenderer(list.getCellRenderer(), this.selectionModel));
        list.registerKeyboardAction(this, KeyStroke.getKeyStroke(32, 0), 0);
        list.addMouseListener(this);
        this.selectionModel.addListSelectionListener(this);
    }

    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    private void toggleSelection(int index) {
        if (index < 0) {
            return;
        }
        if (this.selectionModel.isSelectedIndex(index)) {
            this.selectionModel.removeSelectionInterval(index, index);
        } else {
            this.selectionModel.addSelectionInterval(index, index);
        }
    }

    public Map<Integer, T> getMap() {
        int selectedIndex = this.list.getSelectedIndex();
        if (!this.map.containsKey(selectedIndex)) {
            this.map.put(selectedIndex, this.list.getSelectedValue());
        } else if (this.map.containsKey(selectedIndex) && this.test != selectedIndex) {
            this.map.remove(selectedIndex);
        }
        this.toggleSelection(selectedIndex);
        this.test = this.list.getSelectedIndex();
        return this.map;
    }

    @Override
    public void mouseClicked(MouseEvent me) {
        int index = this.list.locationToIndex(me.getPoint());
        if (index < 0) {
            return;
        }
        if (me.getX() > this.list.getCellBounds((int)index, (int)index).x + this.hotspot) {
            return;
        }
        this.toggleSelection(index);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.list.repaint(this.list.getCellBounds(e.getFirstIndex(), e.getLastIndex()));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.toggleSelection(this.list.getSelectedIndex());
    }
}

