/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.work.internal.tunables;

import java.awt.Component;
import java.awt.Dimension;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.internal.tunables.utils.GUIDefaults;
import org.cytoscape.work.swing.AbstractGUITunableHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringHandler
extends AbstractGUITunableHandler
implements DocumentListener {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private JTextField textField;
    private boolean readOnly;
    private boolean isUpdating;

    public StringHandler(Field f, Object o, Tunable t) {
        super(f, o, t);
        this.init();
    }

    public StringHandler(Method getter, Method setter, Object instance, Tunable tunable) {
        super(getter, setter, instance, tunable);
        this.init();
    }

    private void init() {
        this.readOnly = this.getParams().getProperty("readOnly", "false").equalsIgnoreCase("true");
        String s = null;
        try {
            s = (String)this.getValue();
        }
        catch (Exception e) {
            logger.error("Could not initialize String Tunable.", (Throwable)e);
            s = "";
        }
        this.textField = new JTextField(s);
        this.textField.setPreferredSize(new Dimension(300, this.textField.getPreferredSize().height));
        this.textField.setHorizontalAlignment(2);
        this.textField.getDocument().addDocumentListener(this);
        JLabel label = new JLabel(this.getDescription());
        GUIDefaults.updateFieldPanel(this.panel, label, (Component)this.textField, this.horizontal);
        GUIDefaults.setTooltip(this.getTooltip(), label, this.textField);
        if (this.readOnly) {
            this.textField.setEditable(false);
        }
    }

    public void update() {
        this.isUpdating = true;
        String s = null;
        try {
            s = (String)this.getValue();
            this.textField.setText(s);
        }
        catch (Exception e) {
            logger.error("Could not set String Tunable.", (Throwable)e);
        }
        this.isUpdating = false;
    }

    public void handle() {
        if (this.isUpdating) {
            return;
        }
        String string = this.textField.getText();
        try {
            if (string != null) {
                this.setValue(string);
            }
        }
        catch (Exception e) {
            logger.error("Could not set String Tunable.", (Throwable)e);
        }
    }

    public String getState() {
        if (this.textField == null) {
            return "";
        }
        String text = this.textField.getText();
        if (text == null) {
            return "";
        }
        try {
            return text;
        }
        catch (Exception e) {
            logger.warn("Could not set String Tunable.", (Throwable)e);
            return "";
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.handle();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.handle();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.handle();
    }
}

