/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.work.internal.tunables;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.internal.tunables.JComboBoxDecorator;
import org.cytoscape.work.internal.tunables.utils.GUIDefaults;
import org.cytoscape.work.swing.AbstractGUITunableHandler;
import org.cytoscape.work.util.ListChangeListener;
import org.cytoscape.work.util.ListSelection;
import org.cytoscape.work.util.ListSingleSelection;

public class ListSingleHandler<T>
extends AbstractGUITunableHandler
implements ActionListener,
ListChangeListener<T> {
    private JComboBox<T> combobox;
    private final JLabel label = new JLabel(this.getDescription());
    private boolean isUpdating;
    private boolean decorated = false;
    private List<T> initialValues;

    public ListSingleHandler(Field field, Object instance, Tunable tunable) {
        super(field, instance, tunable);
        this.init();
    }

    public ListSingleHandler(Method getter, Method setter, Object instance, Tunable tunable) {
        super(getter, setter, instance, tunable);
        this.init();
    }

    private ListSingleSelection<T> getSingleSelection() {
        try {
            return (ListSingleSelection)this.getValue();
        }
        catch (Exception e) {
            throw new IllegalStateException("bad ListSingleSelection object", e);
        }
    }

    private void init() {
        Object[] values;
        this.label.setVerticalTextPosition(0);
        Object selectedValue = null;
        if (this.getSingleSelection() == null || this.getSingleSelection().getPossibleValues() == null) {
            values = new Object[1];
        } else {
            this.initialValues = new ArrayList<T>(this.getSingleSelection().getPossibleValues());
            values = this.getSingleSelection().getPossibleValues().toArray();
            selectedValue = this.getSingleSelection().getSelectedValue();
        }
        this.combobox = new JComboBox<Object>(values);
        this.combobox.getModel().setSelectedItem(selectedValue);
        this.combobox.addActionListener(this);
        String decorate = this.getParams().getProperty("lookup");
        if (decorate != null) {
            this.decorated = true;
            if (decorate.equalsIgnoreCase("begins")) {
                JComboBoxDecorator.decorate(this.combobox, Arrays.asList(values), true);
            } else if (decorate.equalsIgnoreCase("contains")) {
                JComboBoxDecorator.decorate(this.combobox, Arrays.asList(values), false);
            }
        }
        GUIDefaults.updateFieldPanel(this.panel, this.label, this.combobox, this.horizontal);
        GUIDefaults.setTooltip(this.getTooltip(), this.label, this.combobox);
        this.combobox.setEnabled(this.combobox.getModel().getSize() > 1);
        this.label.setEnabled(this.combobox.isEnabled());
        this.panel.setVisible(this.combobox.getModel().getSize() > 0);
        ListSingleSelection<T> singleSelection = this.getSingleSelection();
        if (singleSelection != null) {
            ListChangeListener found = null;
            for (ListChangeListener listener : singleSelection.getListeners()) {
                if (!(listener instanceof AbstractGUITunableHandler) || !((AbstractGUITunableHandler)listener).getQualifiedName().equals(this.getQualifiedName())) continue;
                found = listener;
            }
            if (found != null) {
                singleSelection.removeListener(found);
            }
            singleSelection.addListener((ListChangeListener)this);
        }
    }

    public void update() {
        this.isUpdating = true;
        if (this.combobox == null) {
            return;
        }
        this.combobox.setSelectedItem(this.getSingleSelection().getSelectedValue());
        if (!this.decorated) {
            this.combobox.setEnabled(this.combobox.getModel().getSize() > 1);
            this.label.setEnabled(this.combobox.isEnabled());
            this.panel.setVisible(this.combobox.getModel().getSize() > 0);
        } else {
            this.combobox.setEnabled(this.combobox.getModel().getSize() >= 1);
            this.label.setEnabled(this.combobox.isEnabled());
            this.panel.setVisible(this.combobox.getModel().getSize() > 0);
        }
        this.isUpdating = false;
    }

    public void handle() {
        if (this.combobox == null || this.isUpdating) {
            return;
        }
        Object selectedItem = this.combobox.getSelectedItem();
        if (selectedItem != null) {
            ListSingleSelection<T> singleSelection = this.getSingleSelection();
            if (this.decorated) {
                if (this.initialValues.contains(selectedItem)) {
                    singleSelection.setSelectedValue(selectedItem);
                }
            } else {
                singleSelection.setSelectedValue(selectedItem);
            }
            try {
                this.setValue(singleSelection);
            }
            catch (Exception e) {
                this.combobox.setForeground(LookAndFeelUtil.getErrorColor());
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, "The value entered cannot be set for " + this.getName() + "!", "Error", 0);
                this.combobox.setForeground(UIManager.getColor("ComboBox.foreground"));
                return;
            }
        }
    }

    public String getState() {
        if (this.combobox == null) {
            return "";
        }
        Object selectedItem = this.combobox.getSelectedItem();
        if (selectedItem == null) {
            return "";
        }
        if (!this.decorated || this.initialValues.contains(selectedItem)) {
            this.getSingleSelection().setSelectedValue(selectedItem);
        }
        return this.getSingleSelection().getSelectedValue().toString();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.handle();
    }

    public void selectionChanged(ListSelection<T> source) {
        this.update();
    }

    public void listChanged(ListSelection<T> source) {
        this.update();
    }
}

