/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.work.internal.task;

import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import org.cytoscape.work.FinishStatus;
import org.cytoscape.work.TaskMonitor;

public class TaskHistory
implements Iterable<Object> {
    public static final TaskMonitor.Level[] levels = TaskMonitor.Level.values();
    public static final FinishStatus.Type[] finishTypes = FinishStatus.Type.values();
    final ConcurrentLinkedQueue<Object> histories = new ConcurrentLinkedQueue();
    volatile FinishListener finishListener;

    public History newHistory() {
        History history = new History();
        this.histories.add(history);
        return history;
    }

    @Override
    public Iterator<Object> iterator() {
        return this.histories.iterator();
    }

    public void clear() {
        this.histories.clear();
    }

    public void setFinishListener(FinishListener finishListener) {
        this.finishListener = finishListener;
    }

    public void addUnnestedMessage(TaskMonitor.Level level, String message) {
        this.histories.add(new Message(level, message));
    }

    public class History
    implements Iterable<Message> {
        volatile byte finishType = (byte)-1;
        volatile Class<?> firstTaskClass;
        final AtomicReference<String> title = new AtomicReference();
        final ConcurrentLinkedQueue<Message> messages = new ConcurrentLinkedQueue();

        protected History() {
        }

        public void setTitle(String newTitle) {
            if (!this.title.compareAndSet(null, newTitle)) {
                this.addMessage(null, newTitle);
            }
        }

        public void setFinishType(FinishStatus.Type finishType) {
            this.finishType = (byte)(finishType == null ? -1 : (byte)finishType.ordinal());
            if (TaskHistory.this.finishListener != null) {
                TaskHistory.this.finishListener.taskFinished(this);
            }
        }

        public void addMessage(TaskMonitor.Level level, String message) {
            this.messages.add(new Message(level, message));
        }

        @Override
        public Iterator<Message> iterator() {
            return this.messages.iterator();
        }

        public String getTitle() {
            return this.title.get();
        }

        public FinishStatus.Type getFinishType() {
            return this.finishType < 0 ? null : finishTypes[this.finishType];
        }

        public boolean hasMessages() {
            return !this.messages.isEmpty();
        }

        public void setFirstTaskClass(Class<?> klass) {
            this.firstTaskClass = klass;
        }

        public Class<?> getFirstTaskClass() {
            return this.firstTaskClass;
        }
    }

    public static class Message {
        final byte levelOrdinal;
        final String message;

        public Message(TaskMonitor.Level level, String message) {
            this.levelOrdinal = (byte)(level == null ? -1 : (byte)level.ordinal());
            this.message = message;
        }

        public TaskMonitor.Level level() {
            return this.levelOrdinal < 0 ? null : levels[this.levelOrdinal];
        }

        public String message() {
            return this.message;
        }
    }

    public static interface FinishListener {
        public void taskFinished(History var1);
    }
}

