/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.work.internal;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEditSupport;
import org.cytoscape.work.swing.undo.SwingUndoSupport;
import org.cytoscape.work.undo.AbstractCyEdit;

public class UndoSupportImpl
implements SwingUndoSupport {
    private UndoManager m_undoManager = new UndoManager();
    private UndoableEditSupport m_undoSupport = new UndoableEditSupport();

    public UndoSupportImpl() {
        this.m_undoSupport.addUndoableEditListener(this.m_undoManager);
    }

    public UndoManager getUndoManager() {
        return this.m_undoManager;
    }

    public UndoableEditSupport getUndoableEditSupport() {
        return this.m_undoSupport;
    }

    public void postEdit(AbstractCyEdit edit) {
        if (edit != null) {
            this.m_undoSupport.postEdit(new SwingEditWrapper(edit));
        }
    }

    public void reset() {
        this.m_undoManager.discardAllEdits();
    }

    private class SwingEditWrapper
    extends AbstractUndoableEdit {
        private final AbstractCyEdit edit;

        SwingEditWrapper(AbstractCyEdit edit) {
            this.edit = edit;
        }

        @Override
        public String getPresentationName() {
            return this.edit.getPresentationName();
        }

        @Override
        public String getUndoPresentationName() {
            return this.edit.getUndoPresentationName();
        }

        @Override
        public String getRedoPresentationName() {
            return this.edit.getRedoPresentationName();
        }

        @Override
        public void undo() {
            super.undo();
            this.edit.undo();
        }

        @Override
        public void redo() {
            super.redo();
            this.edit.redo();
        }
    }
}

