/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.internal.vector;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import org.cytoscape.cg.internal.paint.RadialGradientPaintFactory;
import org.cytoscape.cg.internal.vector.GradientLayerCustomGraphics;
import org.cytoscape.cg.internal.vector.PaintCustomGraphics;

public class GradientOvalLayer
extends GradientLayerCustomGraphics {
    private static final String NAME = "Oval Gradient";

    public GradientOvalLayer(Long id) {
        super(id, NAME);
    }

    @Override
    protected void renderImage(Graphics graphics) {
        super.renderImage(graphics);
        Graphics2D g2d = (Graphics2D)graphics;
        this.update();
        g2d.setPaint(this.paintFactory.getPaint(this.shape.getBounds2D()));
        g2d.fillOval(this.rendered.getMinX(), this.rendered.getMinY(), this.width, this.height);
    }

    public void update() {
        this.layers.clear();
        this.shape = new Ellipse2D.Double(-this.width / 2, -this.height / 2, this.width, this.height);
        this.paintFactory = new RadialGradientPaintFactory(this.colorList, this.stopList);
        PaintCustomGraphics cg = new PaintCustomGraphics(this.shape, this.paintFactory);
        this.layers.add(cg);
    }

    public String toSerializableString() {
        return this.makeSerializableString(this.displayName);
    }
}

