/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.internal.util;

import java.awt.Color;
import javax.swing.ImageIcon;

public abstract class VisualPropertyIcon<T>
extends ImageIcon {
    private static final long serialVersionUID = 3318566366920258692L;
    public static final Color DEFAULT_ICON_COLOR = Color.DARK_GRAY;
    public static final int DEFAULT_ICON_SIZE = 32;
    protected final int height;
    protected final int width;
    protected final Color color;
    protected final T value;
    protected final String name;
    protected int leftPad;
    protected int bottomPad;

    public VisualPropertyIcon(T value, int width, int height, String name) {
        if (value == null) {
            throw new IllegalArgumentException("'value' must not be null.");
        }
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("Width and height should be positive integers: (w, h) = (" + width + ", " + height + ")");
        }
        this.value = value;
        this.width = width;
        this.height = height;
        this.name = name;
        this.color = DEFAULT_ICON_COLOR;
    }

    public T getValue() {
        return this.value;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    public String getName() {
        return this.name;
    }

    public Color getColor() {
        return this.color;
    }

    public void setLeftPadding(int pad) {
        this.leftPad = pad;
    }

    public void setBottomPadding(int pad) {
        this.bottomPad = pad;
    }
}

