/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.internal.util;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.cytoscape.cg.internal.charts.AbstractChartEditor;
import org.cytoscape.cg.internal.util.MathUtil;
import org.cytoscape.util.swing.LookAndFeelUtil;

public class PointPicker
extends JPanel {
    private static final Point2D DEFAULT_VALUE = new Point2D.Double(0.5, 0.5);
    private int size;
    private float fieldWidth;
    private float fieldHeight;
    private float fieldX;
    private float fieldY;
    private float fieldCenterX;
    private float fieldCenterY;
    private float targetSize;
    private Point2D value;
    private Point2D position = new Point2D.Double();
    private JPanel canvas;
    private JLabel xLbl;
    private JTextField xTxt;
    private JLabel yLbl;
    private JTextField yTxt;

    public PointPicker(int size, int targetSize) {
        this(size, targetSize, DEFAULT_VALUE);
    }

    public PointPicker(int size, int targetSize, Point2D value) {
        if (value == null) {
            value = DEFAULT_VALUE;
        }
        float EXTRA_PADDING = 2.0f;
        this.value = value;
        this.size = size;
        this.targetSize = targetSize;
        this.fieldHeight = this.fieldWidth = (float)(size - targetSize) - 4.0f;
        this.fieldX = (float)(targetSize / 2) + 2.0f;
        this.fieldY = (float)(targetSize / 2) + 2.0f;
        this.fieldCenterX = this.fieldX + this.fieldWidth / 2.0f;
        this.fieldCenterY = this.fieldY + this.fieldHeight / 2.0f;
        this.position = this.convertToPosition(new Point2D.Double(value.getX(), value.getY()));
        this.init();
        this.updateTextFields();
    }

    public Point2D getValue() {
        return (Point2D)this.value.clone();
    }

    public void setValue(Point2D value) {
        if (!this.value.equals(value)) {
            Point2D oldValue = this.value;
            this.value = value;
            Point2D p = this.convertToPosition(new Point2D.Double(value.getX(), value.getY()));
            this.moveTarget(p.getX(), p.getY());
            this.updateTextFields();
            this.firePropertyChange("value", oldValue, value);
        }
    }

    private void init() {
        this.xLbl = new JLabel("x:");
        this.yLbl = new JLabel("y:");
        this.setOpaque(!LookAndFeelUtil.isAquaLAF());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(this.getCanvas(), -2, -1, -2).addGap(4).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addGroup(layout.createSequentialGroup().addComponent(this.xLbl).addComponent(this.getXTxt())).addGroup(layout.createSequentialGroup().addComponent(this.yLbl).addComponent(this.getYTxt()))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addComponent(this.getCanvas()).addGroup(layout.createSequentialGroup().addGap((int)this.fieldY).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.xLbl).addComponent(this.getXTxt(), -2, -1, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.yLbl).addComponent(this.getYTxt(), -2, -1, -2))));
        LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this.xLbl, this.yLbl, this.getXTxt(), this.getYTxt()});
        this.add(this.getCanvas());
    }

    private JPanel getCanvas() {
        if (this.canvas == null) {
            this.canvas = new JPanel(){

                @Override
                protected void paintComponent(Graphics g) {
                    PointPicker.this.paintCanvas(g);
                }
            };
            this.canvas.setOpaque(!LookAndFeelUtil.isAquaLAF());
            this.canvas.setMinimumSize(new Dimension(this.size, this.size));
            this.canvas.setPreferredSize(new Dimension(this.size, this.size));
            MouseAdapter mouseAdapter = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    PointPicker.this.mouseCheck(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    PointPicker.this.mouseCheck(e);
                    if (SwingUtilities.isLeftMouseButton(e)) {
                        PointPicker.this.setValue(PointPicker.this.convertToValue(PointPicker.this.position));
                    }
                }

                @Override
                public void mouseDragged(MouseEvent e) {
                    PointPicker.this.mouseCheck(e);
                }
            };
            this.canvas.addMouseMotionListener(mouseAdapter);
            this.canvas.addMouseListener(mouseAdapter);
        }
        return this.canvas;
    }

    private JTextField getXTxt() {
        if (this.xTxt == null) {
            this.xTxt = new JTextField();
            this.xTxt.setInputVerifier(new AbstractChartEditor.DoubleInputVerifier());
            this.xTxt.setMinimumSize(new Dimension(60, this.xTxt.getMinimumSize().height));
            this.xTxt.setHorizontalAlignment(11);
            this.xTxt.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    PointPicker.this.onTextFieldUpdated();
                }
            });
        }
        return this.xTxt;
    }

    private JTextField getYTxt() {
        if (this.yTxt == null) {
            this.yTxt = new JTextField();
            this.yTxt.setInputVerifier(new AbstractChartEditor.DoubleInputVerifier());
            this.yTxt.setMinimumSize(new Dimension(60, this.yTxt.getMinimumSize().height));
            this.yTxt.setHorizontalAlignment(11);
            this.yTxt.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    PointPicker.this.onTextFieldUpdated();
                }
            });
        }
        return this.yTxt;
    }

    private void mouseCheck(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            this.moveTarget(e.getX(), e.getY());
        }
    }

    private void moveTarget(double x, double y) {
        Line2D.Double line = new Line2D.Double(this.fieldCenterX, this.fieldCenterY, x, y);
        Point2D[] ips = MathUtil.getIntersectionPoints(line, new Rectangle2D.Float(this.fieldX, this.fieldY, this.fieldWidth, this.fieldHeight));
        Point2D ip = null;
        for (Point2D p : ips) {
            if (p == null) continue;
            ip = p;
            break;
        }
        if (ip != null) {
            this.position.setLocation(ip.getX(), ip.getY());
        } else {
            this.position.setLocation(x, y);
        }
        SwingUtilities.getRoot(this).repaint();
        this.updateTextFields();
    }

    private void updateTextFields() {
        Point2D value = this.convertToValue(this.position);
        this.getXTxt().setText("" + (double)Math.round(value.getX() * 100.0) / 100.0);
        this.getYTxt().setText("" + (double)Math.round(value.getY() * 100.0) / 100.0);
    }

    private void onTextFieldUpdated() {
        try {
            double y;
            double x = Double.parseDouble(this.getXTxt().getText());
            if (x < 0.0) {
                x = 0.0;
            }
            if (x > 1.0) {
                x = 1.0;
            }
            if ((y = Double.parseDouble(this.getYTxt().getText())) < 0.0) {
                y = 0.0;
            }
            if (y > 1.0) {
                y = 1.0;
            }
            this.setValue(new Point2D.Double(x, y));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private Point2D convertToValue(Point2D position) {
        return new Point2D.Double((position.getX() - (double)this.fieldX) / (double)this.fieldWidth, (position.getY() - (double)this.fieldY) / (double)this.fieldHeight);
    }

    private Point2D convertToPosition(Point2D value) {
        return new Point2D.Double(value.getX() * (double)this.fieldWidth + (double)this.fieldX, value.getY() * (double)this.fieldHeight + (double)this.fieldY);
    }

    protected void paintCanvas(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int x = (int)this.fieldX;
        int y = (int)this.fieldY;
        int w = (int)this.fieldWidth;
        int h = (int)this.fieldHeight;
        g2.setColor(UIManager.getColor("Panel.background"));
        g2.fillRect(x, y, w, h);
        g2.setColor(UIManager.getColor("Label.disabledForeground"));
        g2.drawRect(x, y, w, h);
        this.drawTarget(g2, 3.2f, UIManager.getColor("Label.foreground"));
        this.drawTarget(g2, 1.0f, UIManager.getColor("Table.background"));
        g2.dispose();
    }

    protected void drawTarget(Graphics2D g2, float strokeWidth, Color strokeColor) {
        double cx = this.position.getX();
        double cy = this.position.getY();
        float d = this.targetSize;
        g2.setStroke(new BasicStroke(strokeWidth, 1, 1));
        g2.setColor(strokeColor);
        g2.drawLine((int)cx, (int)(cy - (double)(d / 2.0f)), (int)cx, (int)(cy + (double)(d / 2.0f)));
        g2.drawLine((int)(cx - (double)(d / 2.0f)), (int)cy, (int)(cx + (double)(d / 2.0f)), (int)cy);
    }
}

