/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.internal.util;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.cytoscape.cg.internal.util.ControlPoint;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.color.BrewerType;
import org.cytoscape.util.color.PaletteType;
import org.cytoscape.util.swing.CyColorPaletteChooser;
import org.cytoscape.util.swing.CyColorPaletteChooserFactory;
import org.cytoscape.util.swing.LookAndFeelUtil;

public class GradientEditor
extends JPanel {
    private List<ControlPoint> controlPoints = new ArrayList<ControlPoint>();
    private ControlPoint selected;
    private Polygon poly = new Polygon();
    private JButton addBtn = new JButton("Add");
    private JButton editBtn = new JButton("Edit");
    private JButton delBtn = new JButton("Delete");
    private int x;
    private int y;
    private int width;
    private int barHeight;
    private List<ActionListener> listeners = new ArrayList<ActionListener>();
    private final CyServiceRegistrar serviceRegistrar;

    public GradientEditor(List<ControlPoint> points, CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
        this.setPoints(points);
        this.init();
    }

    public GradientEditor(List<Float> positions, List<Color> colors, CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
        ArrayList<ControlPoint> points = new ArrayList<ControlPoint>();
        if (positions != null) {
            for (int i = 0; i < positions.size(); ++i) {
                float pos = positions.get(i).floatValue();
                Color c = null;
                if (colors != null && colors.size() > i) {
                    c = colors.get(i);
                }
                points.add(new ControlPoint(c != null ? c : Color.WHITE, pos));
            }
        }
        this.setPoints(points);
        this.init();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        Component[] components = this.getComponents();
        for (int i = 0; i < components.length; ++i) {
            components[i].setEnabled(enabled);
        }
        this.repaint(0L);
    }

    public void addActionListener(ActionListener listener) {
        this.listeners.add(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void paintComponent(Graphics g1d) {
        int i;
        super.paintComponent(g1d);
        Graphics2D g = (Graphics2D)g1d;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.width = this.getWidth() - 30;
        this.x = 10;
        this.y = 20;
        this.barHeight = 25;
        Color lineColor = UIManager.getColor(this.isEnabled() ? "Label.disabledForeground" : "Separator.foreground");
        for (i = 0; i < this.controlPoints.size() - 1; ++i) {
            ControlPoint now = this.controlPoints.get(i);
            ControlPoint next = this.controlPoints.get(i + 1);
            int size = (int)((next.getPosition() - now.getPosition()) * (float)this.width);
            g.setPaint(new GradientPaint(this.x, this.y, now.getColor(), this.x + size, this.y, next.getColor()));
            g.fillRect(this.x, this.y, size + 1, this.barHeight);
            this.x += size;
        }
        g.setColor(lineColor);
        g.drawRect(10, this.y, this.width, this.barHeight - 1);
        for (i = 0; i < this.controlPoints.size(); ++i) {
            ControlPoint pt = this.controlPoints.get(i);
            g.translate(10.0f + (float)this.width * pt.getPosition(), (double)(this.y + this.barHeight));
            g.setColor(pt.getColor());
            g.fillPolygon(this.poly);
            g.setColor(pt == this.selected ? UIManager.getColor("Focus.color") : lineColor);
            g.setStroke(new BasicStroke(pt == this.selected ? 1.5f : 1.0f));
            g.drawPolygon(this.poly);
            g.translate(-10.0f - (float)this.width * pt.getPosition(), (double)(-this.y - this.barHeight));
        }
    }

    public void addPoint(float pos, Color col) {
        ControlPoint point = new ControlPoint(col, pos);
        for (int i = 0; i < this.controlPoints.size() - 1; ++i) {
            ControlPoint now = this.controlPoints.get(i);
            ControlPoint next = this.controlPoints.get(i + 1);
            if (!(now.getPosition() <= pos) || !(next.getPosition() >= pos)) continue;
            this.controlPoints.add(i + 1, point);
            break;
        }
        this.repaint(0L);
    }

    public void setStart(Color col) {
        this.controlPoints.get(0).setColor(col);
        this.repaint(0L);
    }

    public void setEnd(Color col) {
        this.controlPoints.get(this.controlPoints.size() - 1).setColor(col);
        this.repaint(0L);
    }

    public void clearPoints() {
        for (int i = 1; i < this.controlPoints.size() - 1; ++i) {
            this.controlPoints.remove(1);
        }
        this.repaint(0L);
        this.fireUpdate();
    }

    public int getControlPointCount() {
        return this.controlPoints.size();
    }

    public float getPointPos(int index) {
        return this.controlPoints.get(index).getPosition();
    }

    public Color getColor(int index) {
        return this.controlPoints.get(index).getColor();
    }

    public List<ControlPoint> getControlPoints() {
        return new ArrayList<ControlPoint>(this.controlPoints);
    }

    public List<Float> getPositions() {
        ArrayList<Float> positions = new ArrayList<Float>(this.controlPoints.size());
        for (int i = 0; i < this.controlPoints.size(); ++i) {
            positions.add(Float.valueOf(this.controlPoints.get(i).getPosition()));
        }
        return positions;
    }

    public List<Color> getColors() {
        ArrayList<Color> colors = new ArrayList<Color>(this.controlPoints.size());
        for (int i = 0; i < this.controlPoints.size(); ++i) {
            colors.add(this.controlPoints.get(i).getColor());
        }
        return colors;
    }

    private void init() {
        this.setLayout(null);
        this.setOpaque(!LookAndFeelUtil.isAquaLAF());
        this.addBtn.setBounds(20, 70, 75, 20);
        this.add(this.addBtn);
        this.editBtn.setBounds(100, 70, 75, 20);
        this.editBtn.setEnabled(false);
        this.add(this.editBtn);
        this.delBtn.setBounds(180, 70, 75, 20);
        this.delBtn.setEnabled(false);
        this.add(this.delBtn);
        this.addBtn.addActionListener(e -> this.addPoint());
        this.delBtn.addActionListener(e -> this.delPoint());
        this.editBtn.addActionListener(e -> this.editPoint());
        LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this.addBtn, this.editBtn, this.delBtn});
        this.poly.addPoint(0, 0);
        this.poly.addPoint(5, 10);
        this.poly.addPoint(-5, 10);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                GradientEditor.this.selectPoint(e.getX(), e.getY());
                GradientEditor.this.repaint(0L);
                if (e.getClickCount() == 2) {
                    GradientEditor.this.editPoint();
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                GradientEditor.this.movePoint(e.getX(), e.getY());
                GradientEditor.this.repaint(0L);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
    }

    private void setPoints(List<ControlPoint> points) {
        this.controlPoints.clear();
        if (points == null || points.isEmpty()) {
            this.controlPoints.add(new ControlPoint(Color.WHITE, 0.0f));
            this.controlPoints.add(new ControlPoint(Color.BLACK, 1.0f));
        } else {
            for (int i = 0; i < points.size() - 1; ++i) {
                if (i == 0) {
                    if (points.get(i) != null) {
                        this.controlPoints.add(new ControlPoint(points.get(i).getColor(), 0.0f));
                    } else {
                        this.controlPoints.add(new ControlPoint(Color.WHITE, 0.0f));
                    }
                    if (points.get(points.size() - 1) != null) {
                        this.controlPoints.add(new ControlPoint(points.get(points.size() - 1).getColor(), 1.0f));
                        continue;
                    }
                    this.controlPoints.add(new ControlPoint(Color.BLACK, 1.0f));
                    continue;
                }
                ControlPoint cp = points.get(i);
                if (cp == null) continue;
                this.addPoint(cp.getPosition(), cp.getColor());
            }
        }
    }

    private void fireUpdate() {
        ActionEvent event = new ActionEvent(this, 0, "");
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).actionPerformed(event);
        }
    }

    private boolean checkPoint(int mx, int my, ControlPoint pt) {
        int dx = (int)Math.abs(10.0f + (float)this.width * pt.getPosition() - (float)mx);
        int dy = Math.abs(this.y + this.barHeight + 7 - my);
        return dx < 5 && dy < 7;
    }

    private void addPoint() {
        ControlPoint point = new ControlPoint(Color.WHITE, 0.5f);
        for (int i = 0; i < this.controlPoints.size() - 1; ++i) {
            ControlPoint now = this.controlPoints.get(i);
            ControlPoint next = this.controlPoints.get(i + 1);
            if (!(now.getPosition() <= 0.5f) || !(next.getPosition() >= 0.5f)) continue;
            this.controlPoints.add(i + 1, point);
            break;
        }
        this.setSelected(point);
        this.sortPoints();
        this.repaint(0L);
        this.fireUpdate();
    }

    private void sortPoints() {
        final ControlPoint firstPt = this.controlPoints.get(0);
        final ControlPoint lastPt = this.controlPoints.get(this.controlPoints.size() - 1);
        Comparator<ControlPoint> compare = new Comparator<ControlPoint>(){

            @Override
            public int compare(ControlPoint first, ControlPoint second) {
                if (first == firstPt) {
                    return -1;
                }
                if (second == lastPt) {
                    return -1;
                }
                float a = first.getPosition();
                float b = second.getPosition();
                return (int)((a - b) * 10000.0f);
            }
        };
        Collections.sort(this.controlPoints, compare);
    }

    private void editPoint() {
        if (this.selected == null) {
            return;
        }
        CyColorPaletteChooserFactory chooserFactory = (CyColorPaletteChooserFactory)this.serviceRegistrar.getService(CyColorPaletteChooserFactory.class);
        CyColorPaletteChooser chooser = chooserFactory.getColorPaletteChooser((PaletteType)BrewerType.ANY, false);
        Color col = chooser.showDialog((Component)this, "Colors", null, this.selected.getColor(), 8);
        if (col != null) {
            this.selected.setColor(col);
            this.repaint(0L);
            this.fireUpdate();
        }
    }

    private void selectPoint(int mx, int my) {
        if (!this.isEnabled()) {
            return;
        }
        for (int i = 1; i < this.controlPoints.size() - 1; ++i) {
            if (!this.checkPoint(mx, my, this.controlPoints.get(i))) continue;
            this.setSelected(this.controlPoints.get(i));
            return;
        }
        if (this.checkPoint(mx, my, this.controlPoints.get(0))) {
            this.setSelected(this.controlPoints.get(0));
            return;
        }
        if (this.checkPoint(mx, my, this.controlPoints.get(this.controlPoints.size() - 1))) {
            this.setSelected(this.controlPoints.get(this.controlPoints.size() - 1));
            return;
        }
        this.setSelected(null);
    }

    private void setSelected(ControlPoint selected) {
        this.selected = selected;
        this.updateButtons();
    }

    private void updateButtons() {
        this.editBtn.setEnabled(this.selected != null);
        this.delBtn.setEnabled(this.selected != null && this.selected != this.controlPoints.get(0) && this.selected != this.controlPoints.get(this.controlPoints.size() - 1));
    }

    private void delPoint() {
        if (!this.isEnabled()) {
            return;
        }
        if (this.selected == null) {
            return;
        }
        if (this.controlPoints.indexOf(this.selected) == 0) {
            return;
        }
        if (this.controlPoints.indexOf(this.selected) == this.controlPoints.size() - 1) {
            return;
        }
        this.controlPoints.remove(this.selected);
        this.setSelected(null);
        this.sortPoints();
        this.repaint(0L);
        this.fireUpdate();
    }

    private void movePoint(int mx, int my) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.selected == null) {
            return;
        }
        if (this.controlPoints.indexOf(this.selected) == 0) {
            return;
        }
        if (this.controlPoints.indexOf(this.selected) == this.controlPoints.size() - 1) {
            return;
        }
        float newPos = (float)(mx - 10) / (float)this.width;
        newPos = Math.min(1.0f, newPos);
        newPos = Math.max(0.0f, newPos);
        this.selected.setPosition(newPos);
        this.sortPoints();
        this.fireUpdate();
    }
}

