/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.internal.paint;

import java.awt.Color;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.cytoscape.cg.internal.paint.GradientPaintFactory;

public class RadialGradientPaintFactory
extends GradientPaintFactory {
    private Point2D center;
    private float size;

    public RadialGradientPaintFactory(List<Color> colors, List<Float> stops) {
        super(colors, stops);
        this.center = new Point2D.Float(0.5f, 0.5f);
        this.size = 0.5f;
    }

    public RadialGradientPaintFactory(List<Color> colors, List<Float> stops, Point2D center, float size) {
        super(colors, stops);
        this.center = center;
        this.size = size;
    }

    @Override
    public Paint getPaint(Rectangle2D bound) {
        double diameter = Math.min(bound.getWidth(), bound.getHeight());
        this.paint = new RadialGradientPaint(this.scale(this.center, bound), (float)((double)this.size * diameter), this.stopArray, this.colorArray);
        return this.paint;
    }
}

