/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.internal.paint;

import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.cytoscape.cg.internal.util.PaintFactory;

public abstract class GradientPaintFactory
implements PaintFactory {
    protected Color[] colorArray;
    protected float[] stopArray;
    protected Paint paint;

    public GradientPaintFactory(List<Color> colorList, List<Float> stopList) {
        this.colorArray = new Color[colorList.size()];
        this.stopArray = new float[colorList.size()];
        for (int index = 0; index < this.colorArray.length; ++index) {
            this.colorArray[index] = colorList.get(index);
            this.stopArray[index] = stopList.get(index).floatValue();
        }
    }

    protected Point2D scale(Point2D point, Rectangle2D bound) {
        double xvalue = point.getX() * bound.getWidth() + bound.getX();
        double yvalue = point.getY() * bound.getHeight() + bound.getY();
        return new Point2D.Float((float)xvalue, (float)yvalue);
    }
}

