/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.internal.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;

public class PropertiesJsonSerializer
extends JsonSerializer<Map<String, Object>> {
    public void serialize(Map<String, Object> map, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        jgen.writeStartObject();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (key == null || value == null) continue;
            if (value.getClass().isArray()) {
                int length = Array.getLength(value);
                jgen.writeArrayFieldStart(key);
                for (int i = 0; i < length; ++i) {
                    jgen.writeObject(Array.get(value, i));
                }
                jgen.writeEndArray();
                continue;
            }
            if (value instanceof Collection) {
                jgen.writeArrayFieldStart(key);
                for (Object v : (Collection)value) {
                    jgen.writeObject(v);
                }
                jgen.writeEndArray();
                continue;
            }
            jgen.writeFieldName(key);
            jgen.writeObject(value);
        }
        jgen.writeEndObject();
    }

    public Class handledType() {
        return Map.class;
    }
}

