/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.internal.gradient.radial;

import java.awt.Color;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.cytoscape.cg.internal.gradient.AbstractGradientLayer;
import org.cytoscape.view.presentation.customgraphics.CustomGraphicLayer;

public class RadialGradientLayer
extends AbstractGradientLayer {
    protected Point2D center;
    protected float radius;
    protected Rectangle2D rectangle = new Rectangle(0, 0, 100, 100);

    public RadialGradientLayer(Point2D center, float radius, List<Float> fractions, List<Color> colors) {
        super(fractions, colors);
        this.center = center;
        this.radius = radius;
        if (this.center == null) {
            this.center = new Point2D.Float(0.5f, 0.5f);
        }
        if (this.radius <= 0.0f) {
            this.radius = 1.0f;
        }
    }

    public Paint getPaint(Rectangle2D bounds) {
        double w = bounds.getWidth();
        double h = bounds.getHeight();
        double cx = w * this.center.getX() + bounds.getX();
        double cy = h * this.center.getY() + bounds.getY();
        Point2D.Double newCenter = new Point2D.Double(cx, cy);
        double delta = newCenter.distance(new Point2D.Double(bounds.getCenterX(), bounds.getCenterY()));
        double r = Math.sqrt(w * w + h * h) / 2.0;
        double newRadius = delta + r * (double)this.radius;
        this.paint = new RadialGradientPaint(newCenter, (float)newRadius, this.fractionArray, this.colorArray);
        return this.paint;
    }

    public Rectangle2D getBounds2D() {
        return this.rectangle;
    }

    public CustomGraphicLayer transform(AffineTransform xform) {
        RadialGradientLayer newLayer = new RadialGradientLayer(this.center, this.radius, this.fractions, this.colors);
        newLayer.rectangle = xform.createTransformedShape(this.rectangle).getBounds2D();
        return newLayer;
    }
}

