/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.internal.gradient.radial;

import java.awt.geom.Point2D;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.cytoscape.cg.internal.gradient.AbstractGradientEditor;
import org.cytoscape.cg.internal.gradient.radial.RadialGradient;
import org.cytoscape.cg.internal.util.PointPicker;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.LookAndFeelUtil;

public class RadialGradientEditor
extends AbstractGradientEditor<RadialGradient> {
    private JLabel centerLbl;
    private PointPicker pointPicker;

    public RadialGradientEditor(RadialGradient gradient, CyServiceRegistrar serviceRegistrar) {
        super(gradient, serviceRegistrar);
    }

    @Override
    protected void createLabels() {
        super.createLabels();
        this.centerLbl = new JLabel("Center:");
    }

    @Override
    protected JPanel getOtherOptionsPnl() {
        JPanel p = super.getOtherOptionsPnl();
        p.setVisible(true);
        GroupLayout layout = new GroupLayout(p);
        p.setLayout(layout);
        layout.setAutoCreateContainerGaps(false);
        layout.setAutoCreateGaps(true);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.centerLbl).addComponent(this.getPointPicker(), -2, -1, -2));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.centerLbl).addComponent(this.getPointPicker(), -2, -1, -2));
        LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this.centerLbl});
        return p;
    }

    private PointPicker getPointPicker() {
        if (this.pointPicker == null) {
            Point2D center = ((RadialGradient)this.gradient).get("cy_center", Point2D.class, new Point2D.Double(0.5, 0.5));
            this.pointPicker = new PointPicker(100, 12, center);
            this.pointPicker.addPropertyChangeListener("value", evt -> {
                Point2D newCenter = (Point2D)evt.getNewValue();
                ((RadialGradient)this.gradient).set("cy_center", newCenter);
            });
        }
        return this.pointPicker;
    }
}

