/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.internal.gradient.linear;

import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.cytoscape.cg.internal.charts.AbstractChartEditor;
import org.cytoscape.cg.internal.gradient.AbstractGradientEditor;
import org.cytoscape.cg.internal.gradient.linear.LinearGradient;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.LookAndFeelUtil;

public class LinearGradientEditor
extends AbstractGradientEditor<LinearGradient> {
    private static final long serialVersionUID = 5997072753907737888L;
    private JLabel angleLbl;
    private JComboBox<Double> angleCmb;
    private static Double[] ANGLES = new Double[]{-315.0, -270.0, -225.0, -180.0, -135.0, -90.0, -45.0, 0.0, 45.0, 90.0, 135.0, 180.0, 225.0, 270.0, 315.0};

    public LinearGradientEditor(LinearGradient gradient, CyServiceRegistrar serviceRegistrar) {
        super(gradient, serviceRegistrar);
    }

    @Override
    protected void createLabels() {
        super.createLabels();
        this.angleLbl = new JLabel("Angle (degrees):");
    }

    @Override
    protected JPanel getOtherOptionsPnl() {
        JPanel p = super.getOtherOptionsPnl();
        p.setVisible(true);
        GroupLayout layout = new GroupLayout(p);
        p.setLayout(layout);
        layout.setAutoCreateContainerGaps(false);
        layout.setAutoCreateGaps(true);
        layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(this.angleLbl).addComponent(this.getAngleCmb(), -2, -1, -2));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.angleLbl).addComponent(this.getAngleCmb(), -2, -1, -2));
        LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this.angleLbl, this.getAngleCmb()});
        return p;
    }

    private JComboBox<Double> getAngleCmb() {
        if (this.angleCmb == null) {
            this.angleCmb = new JComboBox<Double>(ANGLES);
            this.angleCmb.setEditable(true);
            ((JLabel)((Object)this.angleCmb.getRenderer())).setHorizontalAlignment(4);
            this.angleCmb.setSelectedItem(((LinearGradient)this.gradient).get("cy_angle", Double.class, 0.0));
            this.angleCmb.setInputVerifier(new AbstractChartEditor.DoubleInputVerifier());
            this.angleCmb.addActionListener(e -> {
                Object angle = this.angleCmb.getSelectedItem();
                ((LinearGradient)this.gradient).set("cy_angle", angle instanceof Number ? ((Number)angle).doubleValue() : 0.0);
            });
        }
        return this.angleCmb;
    }
}

