/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.internal.gradient.linear;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Map;
import org.cytoscape.cg.internal.gradient.AbstractGradient;
import org.cytoscape.cg.internal.gradient.linear.LinearGradientLayer;

public class LinearGradient
extends AbstractGradient<LinearGradientLayer> {
    public static final String FACTORY_ID = "org.cytoscape.LinearGradient";
    public static final String DISPLAY_NAME = "Linear Gradient";
    public static final String ANGLE = "cy_angle";
    private BufferedImage renderedImg;
    private volatile boolean dirty = true;

    public LinearGradient(String input) {
        super(DISPLAY_NAME, input);
    }

    public LinearGradient(LinearGradient gradient) {
        super(gradient);
    }

    public LinearGradient(Map<String, Object> properties) {
        super(DISPLAY_NAME, properties);
    }

    public synchronized Image getRenderedImage() {
        if (this.dirty) {
            this.updateRendereredImage();
            this.dirty = false;
        }
        return this.renderedImg;
    }

    @Override
    public String getId() {
        return FACTORY_ID;
    }

    @Override
    public synchronized void set(String key, Object value) {
        super.set(key, value);
        if (ANGLE.equalsIgnoreCase(key) || "cy_gradientFractions".equalsIgnoreCase(key) || "cy_gradientColors".equalsIgnoreCase(key)) {
            this.dirty = true;
        }
    }

    @Override
    public Class<?> getSettingType(String key) {
        if (key.equalsIgnoreCase(ANGLE)) {
            return Double.class;
        }
        return super.getSettingType(key);
    }

    @Override
    protected LinearGradientLayer createLayer() {
        LinearGradientLayer layer = null;
        Double angle = this.get(ANGLE, Double.class, 0.0);
        List<Float> fractions = this.getList("cy_gradientFractions", Float.class);
        List<Color> colors = this.getList("cy_gradientColors", Color.class);
        if (angle != null && fractions.size() > 1) {
            layer = new LinearGradientLayer(angle, fractions, colors);
        }
        return layer;
    }

    private void updateRendereredImage() {
        LinearGradientLayer layer = this.createLayer();
        if (layer != null) {
            Rectangle rect = layer.getBounds2D().getBounds();
            this.renderedImg = new BufferedImage(rect.width, rect.height, 2);
            Graphics2D g2d = this.renderedImg.createGraphics();
            g2d.setPaint(layer.getPaint(rect));
            g2d.fill(rect);
        } else {
            this.renderedImg = new BufferedImage(24, 24, 2);
        }
    }
}

