/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.internal.charts.ring;

import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.cytoscape.cg.internal.charts.AbstractChartEditor;
import org.cytoscape.cg.internal.charts.ring.RingChart;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.LookAndFeelUtil;

public class RingChartEditor
extends AbstractChartEditor<RingChart> {
    private JLabel startAngleLbl;
    private JComboBox<Double> startAngleCmb;
    private JLabel holeLbl;
    private JTextField holeTxt;

    public RingChartEditor(RingChart chart, CyServiceRegistrar serviceRegistrar) {
        super(chart, Number.class, false, false, false, true, false, false, false, false, serviceRegistrar);
        this.domainLabelPositionLbl.setVisible(false);
        this.getDomainLabelPositionCmb().setVisible(false);
    }

    @Override
    protected void createLabels() {
        super.createLabels();
        this.startAngleLbl = new JLabel("Start Angle (degrees):");
        this.holeLbl = new JLabel("Hole Size (0.0-1.0):");
    }

    @Override
    protected JPanel getOtherAdvancedOptionsPnl() {
        JPanel p = super.getOtherAdvancedOptionsPnl();
        p.setVisible(true);
        GroupLayout layout = new GroupLayout(p);
        p.setLayout(layout);
        layout.setAutoCreateContainerGaps(false);
        layout.setAutoCreateGaps(!LookAndFeelUtil.isAquaLAF());
        layout.setHorizontalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.startAngleLbl).addComponent(this.holeLbl)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, true).addComponent(this.getStartAngleCmb(), -2, -1, -2).addComponent(this.getHoleTxt(), -2, -1, -2)));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.startAngleLbl).addComponent(this.getStartAngleCmb())).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.holeLbl).addComponent(this.getHoleTxt())));
        return p;
    }

    private JComboBox<Double> getStartAngleCmb() {
        if (this.startAngleCmb == null) {
            this.startAngleCmb = this.createAngleComboBox(this.chart, "cy_startAngle", ANGLES);
        }
        return this.startAngleCmb;
    }

    private JTextField getHoleTxt() {
        if (this.holeTxt == null) {
            this.holeTxt = new JTextField("" + ((RingChart)this.chart).get("cy_holeSize", Double.class, 0.4));
            this.holeTxt.setToolTipText("Diameter of the ring hole, as a proportion of the entire plot");
            this.holeTxt.setInputVerifier(new AbstractChartEditor.DoubleInputVerifier());
            this.holeTxt.setPreferredSize(new Dimension(60, this.holeTxt.getMinimumSize().height));
            this.holeTxt.setHorizontalAlignment(11);
            this.holeTxt.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    try {
                        double angle = Double.valueOf(RingChartEditor.this.holeTxt.getText().trim());
                        ((RingChart)RingChartEditor.this.chart).set("cy_holeSize", angle);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            });
        }
        return this.holeTxt;
    }
}

