/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.internal.charts.pie;

import java.awt.Color;
import java.awt.Image;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.cytoscape.cg.internal.charts.AbstractChart;
import org.cytoscape.cg.internal.charts.pie.PieLayer;
import org.cytoscape.cg.model.Rotation;
import org.cytoscape.model.CyRow;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.presentation.property.values.CyColumnIdentifier;

public class PieChart
extends AbstractChart<PieLayer> {
    public static final String FACTORY_ID = "org.cytoscape.PieChart";
    public static final String DISPLAY_NAME = "Pie Chart";
    public static final String START_ANGLE = "cy_startAngle";
    public static ImageIcon ICON;

    public PieChart(Map<String, Object> properties, CyServiceRegistrar serviceRegistrar) {
        super(DISPLAY_NAME, properties, serviceRegistrar);
    }

    public PieChart(PieChart chart, CyServiceRegistrar serviceRegistrar) {
        super(chart, serviceRegistrar);
    }

    public PieChart(String input, CyServiceRegistrar serviceRegistrar) {
        super(DISPLAY_NAME, input, serviceRegistrar);
    }

    public Image getRenderedImage() {
        return ICON.getImage();
    }

    @Override
    public String getId() {
        return FACTORY_ID;
    }

    @Override
    public Map<String, List<Double>> getDataFromColumns(CyRow row, List<CyColumnIdentifier> columnNames) {
        HashMap<String, List<Double>> data = new HashMap<String, List<Double>>();
        Map<String, List<Double>> rawData = super.getDataFromColumns(row, columnNames);
        ArrayList<Double> allValues = new ArrayList<Double>();
        for (List<Double> values : rawData.values()) {
            allValues.addAll(values);
        }
        data.put("Values", allValues);
        return data;
    }

    @Override
    public Class<?> getSettingType(String key) {
        if (key.equalsIgnoreCase(START_ANGLE)) {
            return Double.class;
        }
        return super.getSettingType(key);
    }

    @Override
    protected PieLayer getLayer(CyRow row) {
        Double startAngle = this.get(START_ANGLE, Double.class, 0.0);
        Rotation rotation = this.get("cy_rotation", Rotation.class, Rotation.ANTICLOCKWISE);
        List<String> labels = this.getItemLabels(row);
        Map<String, List<Double>> data = this.getData(row);
        List<Color> colors = this.getColors(data);
        Boolean showLabels = this.get("cy_showItemLabels", Boolean.class, false);
        float itemFontSize = PieChart.convertFontSize(this.get("cy_itemLabelFontSize", Integer.class, 1));
        Float borderWidth = this.get("cy_borderWidth", Float.class, Float.valueOf(0.25f));
        Color borderColor = this.get("cy_borderColor", Color.class, Color.DARK_GRAY);
        PieLayer layer = new PieLayer(data, labels, showLabels, itemFontSize, colors, borderWidth.floatValue(), borderColor, startAngle, rotation);
        return layer;
    }

    static {
        try {
            ICON = new ImageIcon(ImageIO.read(PieChart.class.getClassLoader().getResource("images/charts/pie-chart.png")));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

