/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.internal.charts.heatmap;

import javax.swing.JComboBox;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.cg.internal.charts.AbstractChartEditor;
import org.cytoscape.cg.internal.charts.ColorSchemeEditor;
import org.cytoscape.cg.internal.charts.LabelPosition;
import org.cytoscape.cg.internal.charts.heatmap.HeatMapChart;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.color.BrewerType;
import org.cytoscape.util.color.PaletteType;
import org.cytoscape.util.swing.IconManager;

public class HeatMapChartEditor
extends AbstractChartEditor<HeatMapChart> {
    public HeatMapChartEditor(HeatMapChart chart, CyServiceRegistrar serviceRegistrar) {
        super(chart, Number.class, false, true, true, false, true, true, true, false, serviceRegistrar);
        this.getBorderPnl().setVisible(false);
    }

    @Override
    public JComboBox<LabelPosition> getDomainLabelPositionCmb() {
        if (this.domainLabelPositionCmb == null) {
            JComboBox<LabelPosition> cmb = super.getDomainLabelPositionCmb();
            cmb.removeItem((Object)LabelPosition.DOWN_45);
            cmb.removeItem((Object)LabelPosition.UP_45);
            cmb.removeItem((Object)LabelPosition.UP_90);
        }
        return this.domainLabelPositionCmb;
    }

    @Override
    protected ColorSchemeEditor<HeatMapChart> getColorSchemeEditor() {
        if (this.colorSchemeEditor == null) {
            this.colorSchemeEditor = new HeatMapColorSchemeEditor((HeatMapChart)this.chart, this.getDefaultPaletteType(), this.getDefaultPaletteName(), ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getCurrentNetwork(), this.serviceRegistrar);
        }
        return this.colorSchemeEditor;
    }

    @Override
    protected PaletteType getDefaultPaletteType() {
        return BrewerType.DIVERGING;
    }

    @Override
    protected String getDefaultPaletteName() {
        return "Red-Yellow-Blue";
    }

    private class HeatMapColorSchemeEditor
    extends ColorSchemeEditor<HeatMapChart> {
        public HeatMapColorSchemeEditor(HeatMapChart chart, PaletteType paletteType, String defaultPaletteName, CyNetwork network, CyServiceRegistrar serviceRegistrar) {
            super(chart, false, paletteType, defaultPaletteName, network, serviceRegistrar);
        }

        @Override
        protected int getPaletteSize() {
            return 3;
        }

        @Override
        protected int getTotal() {
            this.total = 4;
            return 4;
        }

        @Override
        protected void style(ColorSchemeEditor.ColorPanel cp, int index) {
            super.style(cp, index);
            cp.setFont(((IconManager)this.serviceRegistrar.getService(IconManager.class)).getIconFont(11.0f));
            String label = "";
            String toolTip = null;
            if (index == 0) {
                label = "\uf062";
                toolTip = "Upper Bound";
            } else if (index == 1) {
                toolTip = "Zero";
            } else if (index == 2) {
                label = "\uf063";
                toolTip = "Lower Bound";
            } else if (index == 3) {
                label = "\uf05e";
                toolTip = "Not Available";
            }
            cp.setText(label);
            cp.setToolTipText(toolTip);
        }
    }
}

