/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.internal.charts.heatmap;

import java.awt.Color;
import java.awt.Image;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.cytoscape.cg.internal.charts.AbstractChart;
import org.cytoscape.cg.internal.charts.LabelPosition;
import org.cytoscape.cg.internal.charts.heatmap.HeatMapLayer;
import org.cytoscape.cg.model.Orientation;
import org.cytoscape.model.CyRow;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.presentation.property.values.CyColumnIdentifier;

public class HeatMapChart
extends AbstractChart<HeatMapLayer> {
    public static final String FACTORY_ID = "org.cytoscape.HeatMapChart";
    public static final String DISPLAY_NAME = "Heat Map Chart";
    public static ImageIcon ICON;

    public HeatMapChart(Map<String, Object> properties, CyServiceRegistrar serviceRegistrar) {
        super(DISPLAY_NAME, properties, serviceRegistrar);
    }

    public HeatMapChart(HeatMapChart chart, CyServiceRegistrar serviceRegistrar) {
        super(chart, serviceRegistrar);
    }

    public HeatMapChart(String input, CyServiceRegistrar serviceRegistrar) {
        super(DISPLAY_NAME, input, serviceRegistrar);
    }

    public Image getRenderedImage() {
        return ICON.getImage();
    }

    @Override
    public String getId() {
        return FACTORY_ID;
    }

    @Override
    protected HeatMapLayer getLayer(CyRow row) {
        List<String> itemLabels = this.getLabelsFromColumn(row, this.get("cy_itemLabelsColumn", CyColumnIdentifier.class));
        List<String> domainLabels = this.getLabelsFromColumn(row, this.get("cy_domainLabelsColumn", CyColumnIdentifier.class));
        List<String> rangeLabels = this.getLabelsFromColumn(row, this.get("cy_rangeLabelsColumn", CyColumnIdentifier.class));
        Boolean global = this.get("cy_globalRange", Boolean.class, true);
        List<Double> range = global != false ? this.getList("cy_range", Double.class) : null;
        Map<String, List<Double>> data = this.getData(row);
        List<Color> colors = this.getColors(data);
        Boolean showDomainAxis = this.get("cy_showDomainAxis", Boolean.class, false);
        Boolean showRangeAxis = this.get("cy_showRangeAxis", Boolean.class, false);
        LabelPosition domainLabelPosition = this.get("cy_domainLabelPosition", LabelPosition.class);
        Color axisColor = this.get("cy_axisColor", Color.class, Color.DARK_GRAY);
        float axisFontSize = HeatMapChart.convertFontSize(this.get("cy_axisLabelFontSize", Integer.class, 1));
        Orientation orientation = this.get("cy_orientation", Orientation.class);
        HeatMapLayer layer = new HeatMapLayer(data, itemLabels, domainLabels, rangeLabels, showDomainAxis, showRangeAxis, domainLabelPosition, colors, axisColor, axisFontSize, range, orientation);
        return layer;
    }

    static {
        try {
            ICON = new ImageIcon(ImageIO.read(HeatMapChart.class.getClassLoader().getResource("images/charts/heatmap-chart.png")));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

