/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.internal.charts.bar;

import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.cg.internal.charts.AbstractChartEditor;
import org.cytoscape.cg.internal.charts.ColorSchemeEditor;
import org.cytoscape.cg.internal.charts.bar.BarChart;
import org.cytoscape.cg.model.Orientation;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.color.BrewerType;
import org.cytoscape.util.color.PaletteType;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.LookAndFeelUtil;

public class BarChartEditor
extends AbstractChartEditor<BarChart> {
    private ButtonGroup typeGrp;
    private JRadioButton groupedRd;
    private JRadioButton stackedRd;
    private JRadioButton heatStripsRd;
    private JRadioButton upDownRd;
    private JLabel separationLbl;
    private JTextField separationTxt;

    public BarChartEditor(BarChart chart, CyServiceRegistrar serviceRegistrar) {
        super(chart, Number.class, false, true, true, true, true, false, true, true, serviceRegistrar);
    }

    @Override
    protected void createLabels() {
        super.createLabels();
        this.separationLbl = new JLabel("Separation (0.0-0.5):");
    }

    @Override
    protected JPanel getOtherBasicOptionsPnl() {
        JPanel p = super.getOtherAdvancedOptionsPnl();
        p.setVisible(true);
        GroupLayout layout = new GroupLayout(p);
        p.setLayout(layout);
        layout.setAutoCreateContainerGaps(false);
        layout.setAutoCreateGaps(!LookAndFeelUtil.isAquaLAF());
        JSeparator sep = new JSeparator();
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, true).addGroup(layout.createSequentialGroup().addComponent(this.getGroupedRd()).addComponent(this.getStackedRd()).addComponent(this.getHeatStripsRd()).addComponent(this.getUpDownRd())).addComponent(sep));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.getGroupedRd()).addComponent(this.getStackedRd()).addComponent(this.getHeatStripsRd()).addComponent(this.getUpDownRd())).addComponent(sep, -2, -1, -2));
        return p;
    }

    @Override
    protected JPanel getOtherAdvancedOptionsPnl() {
        JPanel p = super.getOtherBasicOptionsPnl();
        GroupLayout layout = new GroupLayout(p);
        p.setLayout(layout);
        layout.setAutoCreateContainerGaps(false);
        layout.setAutoCreateGaps(!LookAndFeelUtil.isAquaLAF());
        layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(this.separationLbl).addComponent(this.getSeparationTxt(), -2, -1, -2));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.separationLbl).addComponent(this.getSeparationTxt()));
        return p;
    }

    private ButtonGroup getTypeGrp() {
        if (this.typeGrp == null) {
            this.typeGrp = new ButtonGroup();
            this.typeGrp.add(this.getGroupedRd());
            this.typeGrp.add(this.getStackedRd());
            this.typeGrp.add(this.getHeatStripsRd());
            this.typeGrp.add(this.getUpDownRd());
        }
        return this.typeGrp;
    }

    private JRadioButton getGroupedRd() {
        if (this.groupedRd == null) {
            this.groupedRd = new JRadioButton("Grouped");
            this.groupedRd.addActionListener(evt -> this.setType());
        }
        return this.groupedRd;
    }

    private JRadioButton getStackedRd() {
        if (this.stackedRd == null) {
            this.stackedRd = new JRadioButton("Stacked");
            this.stackedRd.addActionListener(evt -> this.setType());
        }
        return this.stackedRd;
    }

    public JRadioButton getHeatStripsRd() {
        if (this.heatStripsRd == null) {
            this.heatStripsRd = new JRadioButton("Heat Strips");
            this.heatStripsRd.addActionListener(evt -> this.setType());
        }
        return this.heatStripsRd;
    }

    public JRadioButton getUpDownRd() {
        if (this.upDownRd == null) {
            this.upDownRd = new JRadioButton("Up-Down");
            this.upDownRd.addActionListener(evt -> this.setType());
        }
        return this.upDownRd;
    }

    private JTextField getSeparationTxt() {
        if (this.separationTxt == null) {
            this.separationTxt = new JTextField("" + ((BarChart)this.chart).get("cy_separation", Double.class, 0.0));
            this.separationTxt.setToolTipText("Percentage of the available space for all bars (0.1 is 10%)");
            this.separationTxt.setInputVerifier(new AbstractChartEditor.DoubleInputVerifier());
            this.separationTxt.setPreferredSize(new Dimension(60, this.separationTxt.getMinimumSize().height));
            this.separationTxt.setHorizontalAlignment(11);
            this.separationTxt.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    try {
                        double sep = Double.parseDouble(BarChartEditor.this.separationTxt.getText());
                        ((BarChart)BarChartEditor.this.chart).set("cy_separation", sep);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            });
        }
        return this.separationTxt;
    }

    private void setType() {
        BarChart.BarChartType type = this.getStackedRd().isSelected() ? BarChart.BarChartType.STACKED : (this.getHeatStripsRd().isSelected() ? BarChart.BarChartType.HEAT_STRIPS : (this.getUpDownRd().isSelected() ? BarChart.BarChartType.UP_DOWN : BarChart.BarChartType.GROUPED));
        ((BarChart)this.chart).set("cy_type", (Object)type);
        this.updateRangeMinMax(true);
        this.getColorSchemeEditor().setPaletteType(this.getDefaultPaletteType());
        this.getColorSchemeEditor().setDefaultPaletteName(this.getDefaultPaletteName());
        this.getColorSchemeEditor().reset(true);
    }

    protected void updateType() {
        BarChart.BarChartType type = ((BarChart)this.chart).get("cy_type", BarChart.BarChartType.class, BarChart.BarChartType.GROUPED);
        JRadioButton typeRd = type == BarChart.BarChartType.STACKED ? this.getStackedRd() : (type == BarChart.BarChartType.HEAT_STRIPS ? this.getHeatStripsRd() : (type == BarChart.BarChartType.UP_DOWN ? this.getUpDownRd() : this.getGroupedRd()));
        this.getTypeGrp().setSelected(typeRd.getModel(), true);
    }

    @Override
    protected void update(boolean recalculateRange) {
        this.updateType();
        super.update(recalculateRange);
    }

    @Override
    protected void updateOptions() {
        super.updateOptions();
        boolean sparklines = this.targetType == CyColumn.class;
        this.getOtherAdvancedOptionsPnl().setVisible(!sparklines);
        if (sparklines) {
            ((BarChart)this.chart).set("cy_orientation", (Object)Orientation.AUTO);
            ((BarChart)this.chart).set("cy_separation", 0.1);
        }
    }

    @Override
    protected double[] minMax(double min, double max, List<? extends Number> values) {
        if (values != null) {
            boolean stacked = this.getStackedRd().isSelected();
            double sum = 0.0;
            for (Number number : values) {
                if (number == null) continue;
                double dv = number.doubleValue();
                if (stacked) {
                    sum += dv;
                    continue;
                }
                min = Math.min(min, dv);
                max = Math.max(max, dv);
            }
            if (stacked) {
                min = Math.min(min, sum);
                max = Math.max(max, sum);
            }
        }
        return new double[]{min, max};
    }

    @Override
    protected ColorSchemeEditor<BarChart> getColorSchemeEditor() {
        if (this.colorSchemeEditor == null) {
            this.colorSchemeEditor = new BarColorSchemeEditor((BarChart)this.chart, this.getDefaultPaletteType(), this.getDefaultPaletteName(), ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getCurrentNetwork(), this.serviceRegistrar);
        }
        return this.colorSchemeEditor;
    }

    @Override
    protected PaletteType getDefaultPaletteType() {
        BarChart.BarChartType type = ((BarChart)this.chart).get("cy_type", BarChart.BarChartType.class);
        return type == BarChart.BarChartType.HEAT_STRIPS || type == BarChart.BarChartType.UP_DOWN ? BrewerType.DIVERGING : super.getDefaultPaletteType();
    }

    @Override
    protected String getDefaultPaletteName() {
        BarChart.BarChartType type = ((BarChart)this.chart).get("cy_type", BarChart.BarChartType.class);
        return type == BarChart.BarChartType.HEAT_STRIPS || type == BarChart.BarChartType.UP_DOWN ? "Red-Blue" : super.getDefaultPaletteName();
    }

    private class BarColorSchemeEditor
    extends ColorSchemeEditor<BarChart> {
        public BarColorSchemeEditor(BarChart chart, PaletteType paletteType, String defaultPaletteName, CyNetwork network, CyServiceRegistrar serviceRegistrar) {
            super(chart, false, paletteType, defaultPaletteName, network, serviceRegistrar);
        }

        @Override
        protected int getTotal() {
            BarChart.BarChartType type = ((BarChart)this.chart).get("cy_type", BarChart.BarChartType.class, BarChart.BarChartType.GROUPED);
            if (type == BarChart.BarChartType.HEAT_STRIPS) {
                this.total = 3;
                return 3;
            }
            if (type == BarChart.BarChartType.UP_DOWN) {
                this.total = 2;
                return 2;
            }
            return super.getTotal();
        }

        @Override
        protected void style(ColorSchemeEditor.ColorPanel cp, int index) {
            super.style(cp, index);
            BarChart.BarChartType type = ((BarChart)this.chart).get("cy_type", BarChart.BarChartType.class, BarChart.BarChartType.GROUPED);
            if (type == BarChart.BarChartType.HEAT_STRIPS || type == BarChart.BarChartType.UP_DOWN) {
                cp.setFont(((IconManager)this.serviceRegistrar.getService(IconManager.class)).getIconFont(11.0f));
                String label = "";
                String toolTip = null;
                if (index == 0) {
                    label = "\uf062";
                    toolTip = "Positive Numbers";
                } else if (index == 1) {
                    label = type == BarChart.BarChartType.UP_DOWN ? "\uf063" : "";
                    toolTip = type == BarChart.BarChartType.UP_DOWN ? "Negative Numbers" : "Zero";
                } else if (index == 2 && type == BarChart.BarChartType.HEAT_STRIPS) {
                    label = "\uf063";
                    toolTip = "Negative Numbers";
                }
                cp.setText(label);
                cp.setToolTipText(toolTip);
            }
        }
    }
}

