/*
 * Decompiled with CFR 0.152.
 */
package csapps.layout.algorithms.circularLayout;

import csapps.layout.algorithms.circularLayout.CircularLayoutContext;
import csapps.layout.algorithms.hierarchicalLayout.Edge;
import csapps.layout.algorithms.hierarchicalLayout.Graph;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cytoscape.model.CyNode;
import org.cytoscape.view.layout.AbstractPartitionLayoutTask;
import org.cytoscape.view.layout.LayoutEdge;
import org.cytoscape.view.layout.LayoutNode;
import org.cytoscape.view.layout.LayoutPartition;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.work.undo.UndoSupport;

public class CircularLayoutAlgorithmTask
extends AbstractPartitionLayoutTask {
    private int[][] bc;
    private boolean[] posSet;
    private boolean[] depthPosSet;
    private Map<Integer, Integer> nodeHeights;
    private List<Integer>[] edgesFrom;
    private Map<Integer, View<CyNode>> nodeViews;
    private Map<Integer, Integer> node2BiComp;
    private boolean[] drawnBiComps;

    public CircularLayoutAlgorithmTask(String displayName, CyNetworkView networkView, Set<View<CyNode>> nodesToLayOut, CircularLayoutContext context, UndoSupport undo) {
        super(displayName, context.singlePartition, networkView, nodesToLayOut, "", undo);
    }

    public void layoutPartition(LayoutPartition partition) {
        int i;
        if (this.cancelled) {
            return;
        }
        int numNodes = partition.nodeCount();
        if (numNodes == 1) {
            return;
        }
        this.nodeViews = new HashMap<Integer, View<CyNode>>(numNodes);
        HashMap<CyNode, Integer> nodeIdexMap = new HashMap<CyNode, Integer>();
        int nodeIndex = 0;
        Iterator nodeIter = partition.getNodeList().iterator();
        while (nodeIter.hasNext() && !this.cancelled) {
            LayoutNode ln = (LayoutNode)nodeIter.next();
            if (ln.isLocked()) continue;
            View nv = ln.getNodeView();
            this.nodeViews.put(nodeIndex, (View<CyNode>)nv);
            nodeIdexMap.put((CyNode)nv.getModel(), nodeIndex);
            ++nodeIndex;
        }
        if (this.cancelled) {
            return;
        }
        LinkedList<Edge> edges = new LinkedList<Edge>();
        Iterator edgeIter = partition.edgeIterator();
        while (edgeIter.hasNext() && !this.cancelled) {
            LayoutEdge ev = (LayoutEdge)edgeIter.next();
            Integer edgeFrom = (Integer)nodeIdexMap.get(ev.getEdge().getSource());
            Integer edgeTo = (Integer)nodeIdexMap.get(ev.getEdge().getTarget());
            if (edgeFrom == null || edgeTo == null) continue;
            edges.add(new Edge(edgeFrom, edgeTo));
            edges.add(new Edge(edgeTo, edgeFrom));
        }
        nodeIdexMap.clear();
        nodeIdexMap = null;
        if (this.cancelled) {
            return;
        }
        Edge[] edge = new Edge[edges.size()];
        edges.toArray(edge);
        Graph graph = new Graph(numNodes, edge);
        if (this.cancelled) {
            return;
        }
        this.posSet = new boolean[this.nodeViews.size()];
        this.depthPosSet = new boolean[this.nodeViews.size()];
        this.bc = graph.biconnectedComponents();
        int maxSize = -1;
        int maxIndex = -1;
        for (i = 0; i < this.bc.length; ++i) {
            if (this.bc[i].length <= maxSize) continue;
            maxSize = this.bc[i].length;
            maxIndex = i;
        }
        if (maxIndex == -1) {
            return;
        }
        if (this.cancelled) {
            return;
        }
        this.drawnBiComps = new boolean[this.bc.length];
        this.node2BiComp = new HashMap<Integer, Integer>();
        for (i = 0; i < this.bc.length; ++i) {
            if (this.bc[i].length <= 3) continue;
            for (int j = 0; j < this.bc[i].length; ++j) {
                this.node2BiComp.put(this.bc[i][j], i);
            }
        }
        double radius = (double)(48 * maxSize) / (Math.PI * 2);
        double deltaAngle = Math.PI * 2 / (double)maxSize;
        double angle = 0.0;
        int startX = (int)radius;
        int startY = (int)radius;
        this.edgesFrom = graph.GetEdgesFrom();
        this.bc[maxIndex] = this.SortInnerCircle(this.bc[maxIndex]);
        for (int i2 = 0; i2 < this.bc[maxIndex].length; ++i2) {
            this.setOffset(this.nodeViews.get(this.bc[maxIndex][i2]), (double)startX + Math.cos(angle) * radius, (double)startY - Math.sin(angle) * radius);
            this.posSet[this.bc[maxIndex][i2]] = true;
            angle += deltaAngle;
        }
        this.drawnBiComps[maxIndex] = true;
        this.nodeHeights = new HashMap<Integer, Integer>();
        this.SetOuterCircle(maxIndex, radius, startX, startY, -1);
        if (this.cancelled) {
            return;
        }
        nodeIter = partition.nodeIterator();
        while (nodeIter.hasNext() && !this.cancelled) {
            LayoutNode ln = (LayoutNode)nodeIter.next();
            View nv = ln.getNodeView();
            ln.setX(((Double)nv.getVisualProperty(BasicVisualLexicon.NODE_X_LOCATION)).doubleValue());
            ln.setY(((Double)nv.getVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION)).doubleValue());
            partition.moveNodeToLocation(ln);
        }
    }

    private void SetOuterCircle(int compIndex, double innerCircleRadius, double startX, double startY, int firstTouched) {
        int i;
        double theAngleHlp;
        double theAngle;
        double pointY;
        int outerNodesCount = 0;
        int rnc = 0;
        HashMap<Integer, Integer> outerCircle = new HashMap<Integer, Integer>();
        for (int i2 = 0; i2 < this.bc[compIndex].length; ++i2) {
            for (int currNeighbour : this.edgesFrom[this.bc[compIndex][i2]]) {
                if (this.posSet[currNeighbour]) continue;
                outerNodesCount += this.NoOfChildren(currNeighbour, outerCircle) + 1;
                outerCircle.put(currNeighbour, 0);
                ++rnc;
            }
        }
        double outerRadius = 1.5 * innerCircleRadius;
        int tryCount = (int)(Math.PI * 2 * outerRadius / 32.0);
        double outerDeltaAngle = Math.PI * 2 / (double)tryCount;
        if ((double)tryCount < 1.2 * (double)outerNodesCount) {
            outerRadius = 38.4 * (double)outerNodesCount / (Math.PI * 2);
            outerDeltaAngle = Math.PI * 2 / (1.2 * (double)outerNodesCount);
            outerNodesCount = (int)((double)outerNodesCount * 1.2);
        } else {
            outerNodesCount = tryCount;
        }
        if (outerNodesCount > 10 && firstTouched != -1) {
            outerNodesCount += 5;
        }
        int[] outerPositionsTaken = new int[outerNodesCount];
        int[] outerPositionsOwners = new int[outerNodesCount];
        for (int i3 = 0; i3 < outerPositionsTaken.length; ++i3) {
            outerPositionsTaken[i3] = -1;
            outerPositionsOwners[i3] = -1;
        }
        double innerDeltaAngle = Math.PI * 2 / (double)this.bc[compIndex].length;
        if (firstTouched != -1) {
            View<CyNode> view = this.nodeViews.get(firstTouched);
            double pointX = (Double)view.getVisualProperty(BasicVisualLexicon.NODE_X_LOCATION);
            pointY = (Double)view.getVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION);
            theAngle = Math.asin((startY - pointY) / Math.sqrt((pointX - startX) * (pointX - startX) + (pointY - startY) * (pointY - startY)));
            theAngleHlp = Math.acos((pointX - startX) / Math.sqrt((pointX - startX) * (pointX - startX) + (pointY - startY) * (pointY - startY)));
            if (theAngleHlp > 1.5707963267948966) {
                theAngle = Math.PI - theAngle;
            }
            if (theAngle < 0.0) {
                theAngle += Math.PI * 2;
            }
            int idPos = (int)(theAngle / outerDeltaAngle) % outerPositionsTaken.length;
            outerPositionsTaken[idPos] = (int)(theAngle / innerDeltaAngle);
            outerPositionsOwners[idPos] = -2;
            if (outerPositionsTaken.length > 10) {
                outerPositionsTaken[(idPos + 1) % outerPositionsTaken.length] = (int)(theAngle / innerDeltaAngle);
                outerPositionsTaken[(idPos + 2) % outerPositionsTaken.length] = (int)(theAngle / innerDeltaAngle);
                outerPositionsTaken[(idPos - 1 + outerPositionsTaken.length) % outerPositionsTaken.length] = (int)(theAngle / innerDeltaAngle);
                outerPositionsTaken[(idPos - 2 + outerPositionsTaken.length) % outerPositionsTaken.length] = (int)(theAngle / innerDeltaAngle);
                outerPositionsOwners[(idPos + 1) % outerPositionsOwners.length] = -2;
                outerPositionsOwners[(idPos + 2) % outerPositionsOwners.length] = -2;
                outerPositionsOwners[(idPos - 1 + outerPositionsOwners.length) % outerPositionsOwners.length] = -2;
                outerPositionsOwners[(idPos - 2 + outerPositionsOwners.length) % outerPositionsOwners.length] = -2;
            }
        }
        HashMap<Integer, Integer> addedNeighbours = new HashMap<Integer, Integer>();
        for (i = 0; i < this.bc[compIndex].length; ++i) {
            Iterator<Integer> iter = this.edgesFrom[this.bc[compIndex][i]].iterator();
            int noOfNeighbours = 0;
            while (iter.hasNext()) {
                int currentNeighbour = iter.next();
                if (this.posSet[currentNeighbour]) continue;
                noOfNeighbours += this.NoOfChildren(currentNeighbour, addedNeighbours) + 1;
                addedNeighbours.put(currentNeighbour, 0);
            }
            if (noOfNeighbours == 0) continue;
            double pointX = (Double)this.nodeViews.get(this.bc[compIndex][i]).getVisualProperty(BasicVisualLexicon.NODE_X_LOCATION);
            pointY = (Double)this.nodeViews.get(this.bc[compIndex][i]).getVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION);
            theAngle = Math.asin((startY - pointY) / Math.sqrt((pointX - startX) * (pointX - startX) + (pointY - startY) * (pointY - startY)));
            theAngleHlp = Math.acos((pointX - startX) / Math.sqrt((pointX - startX) * (pointX - startX) + (pointY - startY) * (pointY - startY)));
            if (theAngleHlp > 1.5707963267948966) {
                theAngle = Math.PI - theAngle;
            }
            if (theAngle < 0.0) {
                theAngle += Math.PI * 2;
            }
            iter = this.edgesFrom[this.bc[compIndex][i]].iterator();
            int startPos = this.BestFreePositionsForAll((int)(theAngle / outerDeltaAngle - (double)noOfNeighbours / 2.0), outerPositionsTaken, outerPositionsOwners, noOfNeighbours, (int)(theAngle / innerDeltaAngle), startX, startY, outerDeltaAngle, outerRadius, this.bc[compIndex].length);
            double startAngle = (double)startPos * outerDeltaAngle;
            if (startAngle < 0.0) continue;
            for (int currentNeighbour : this.edgesFrom[this.bc[compIndex][i]]) {
                int j;
                if (this.posSet[currentNeighbour]) continue;
                this.posSet[currentNeighbour] = true;
                int holeDepth = this.NoOfChildren(currentNeighbour, addedNeighbours);
                for (j = 0; j < holeDepth / 2; ++j) {
                    outerPositionsOwners[startPos % outerPositionsOwners.length] = -3;
                    outerPositionsTaken[startPos % outerPositionsOwners.length] = (int)(theAngle / innerDeltaAngle);
                    ++startPos;
                    if (!((startAngle += outerDeltaAngle) > Math.PI * 2)) continue;
                    startAngle -= Math.PI * 2;
                }
                this.setOffset(this.nodeViews.get(currentNeighbour), startX + Math.cos(startAngle) * outerRadius, startY - Math.sin(startAngle) * outerRadius);
                outerPositionsOwners[startPos % outerPositionsOwners.length] = currentNeighbour;
                outerPositionsTaken[startPos % outerPositionsOwners.length] = (int)(theAngle / innerDeltaAngle);
                ++startPos;
                startAngle += outerDeltaAngle;
                if (startAngle > Math.PI * 2) {
                    startAngle -= Math.PI * 2;
                }
                for (j = 0; j < holeDepth / 2; ++j) {
                    outerPositionsOwners[startPos % outerPositionsOwners.length] = -3;
                    outerPositionsTaken[startPos % outerPositionsOwners.length] = (int)(theAngle / innerDeltaAngle);
                    ++startPos;
                    if (!((startAngle += outerDeltaAngle) > Math.PI * 2)) continue;
                    startAngle -= Math.PI * 2;
                }
            }
        }
        for (i = 0; i < this.bc[compIndex].length; ++i) {
            for (int currentNeighbour : this.edgesFrom[this.bc[compIndex][i]]) {
                if (!addedNeighbours.containsKey(currentNeighbour)) continue;
                View<CyNode> view = this.nodeViews.get(currentNeighbour);
                double pointX = (Double)view.getVisualProperty(BasicVisualLexicon.NODE_X_LOCATION);
                pointY = (Double)view.getVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION);
                theAngle = Math.asin((startY - pointY) / Math.sqrt((pointX - startX) * (pointX - startX) + (pointY - startY) * (pointY - startY)));
                theAngleHlp = Math.acos((pointX - startX) / Math.sqrt((pointX - startX) * (pointX - startX) + (pointY - startY) * (pointY - startY)));
                if (theAngleHlp > 1.5707963267948966) {
                    theAngle = Math.PI - theAngle;
                }
                if (theAngle < 0.0) {
                    theAngle += Math.PI * 2;
                }
                for (int j = 0; j < this.posSet.length; ++j) {
                    this.depthPosSet[j] = this.posSet[j];
                }
                this.EachNodeHeight(currentNeighbour);
                this.DFSSetPos(currentNeighbour, theAngle, outerRadius - innerCircleRadius);
            }
        }
    }

    private int NoOfChildren(int nodeID, Map<Integer, Integer> outerCircle) {
        int toReturn = 0;
        for (int currNeigh : this.edgesFrom[nodeID]) {
            if (this.posSet[currNeigh] || outerCircle.containsKey(currNeigh)) continue;
            ++toReturn;
        }
        if (toReturn > 7) {
            return 7;
        }
        return toReturn;
    }

    private int[] SortInnerCircle(int[] icNodes) {
        int deltaG;
        int deltaM;
        int i;
        LinkedList<Integer> greedyNodes = new LinkedList<Integer>();
        LinkedList<Integer> modestNodes = new LinkedList<Integer>();
        HashMap<Integer, Integer> forFunct = new HashMap<Integer, Integer>();
        for (i = 0; i < icNodes.length; ++i) {
            forFunct.put(icNodes[i], 0);
        }
        for (i = 0; i < icNodes.length; ++i) {
            int tmp = this.NoOfChildren(icNodes[i], forFunct);
            if (tmp > 4) {
                greedyNodes.add(icNodes[i]);
                continue;
            }
            modestNodes.add(icNodes[i]);
        }
        int[] toReturn = new int[icNodes.length];
        int gNo = greedyNodes.size();
        int mNo = modestNodes.size();
        if (gNo == 0) {
            deltaM = mNo;
            deltaG = 0;
        } else if (mNo == 0) {
            deltaG = gNo;
            deltaM = 0;
        } else if (gNo > mNo) {
            deltaM = 1;
            deltaG = gNo / mNo;
        } else {
            deltaG = 1;
            deltaM = mNo / gNo;
        }
        int x = 0;
        Iterator iterM = modestNodes.iterator();
        Iterator iterG = greedyNodes.iterator();
        while (iterM.hasNext() && iterG.hasNext()) {
            int i2;
            for (i2 = 0; i2 < deltaG; ++i2) {
                toReturn[x++] = (Integer)iterG.next();
            }
            for (i2 = 0; i2 < deltaM; ++i2) {
                toReturn[x++] = (Integer)iterM.next();
            }
        }
        while (iterG.hasNext()) {
            toReturn[x++] = (Integer)iterG.next();
        }
        while (iterM.hasNext()) {
            toReturn[x++] = (Integer)iterM.next();
        }
        return toReturn;
    }

    private void DFSSetPos(int nodeID, double theAngle, double theRadius) {
        Integer component = this.node2BiComp.get(nodeID);
        if (component != null && !this.drawnBiComps[component]) {
            int comp = this.node2BiComp.get(nodeID);
            View<CyNode> view = this.nodeViews.get(nodeID);
            double centerX = (Double)view.getVisualProperty(BasicVisualLexicon.NODE_X_LOCATION);
            double centerY = (Double)view.getVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION);
            double radius = (double)(48 * this.bc[comp].length) / (Math.PI * 2);
            double deltaAngle = Math.PI * 2 / (double)this.bc[comp].length;
            double currAngle = theAngle - Math.PI - deltaAngle;
            if (currAngle < 0.0) {
                currAngle += Math.PI * 2;
            }
            centerX += Math.cos(theAngle) * radius * 4.0;
            centerY -= Math.sin(theAngle) * radius * 4.0;
            this.drawnBiComps[comp] = true;
            this.bc[comp] = this.SortInnerCircle(this.bc[comp]);
            boolean oneAtLeast = false;
            for (int i = 0; i < this.bc[comp].length; ++i) {
                if (this.posSet[this.bc[comp][i]]) continue;
                this.setOffset(this.nodeViews.get(this.bc[comp][i]), centerX + Math.cos(currAngle) * radius, centerY - Math.sin(currAngle) * radius);
                this.posSet[this.bc[comp][i]] = true;
                oneAtLeast = true;
                currAngle -= deltaAngle;
                if (!(currAngle < 0.0)) continue;
                currAngle += Math.PI * 2;
            }
            if (oneAtLeast) {
                this.setOffset(this.nodeViews.get(nodeID), (Double)this.nodeViews.get(nodeID).getVisualProperty(BasicVisualLexicon.NODE_X_LOCATION) + Math.cos(theAngle) * 3.0 * radius, (Double)this.nodeViews.get(nodeID).getVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION) - Math.sin(theAngle) * 3.0 * radius);
                this.SetOuterCircle(comp, radius, centerX, centerY, nodeID);
            }
        } else {
            int currentNeighbour;
            Iterator<Integer> iter = this.edgesFrom[nodeID].iterator();
            double startAngle = theAngle + 1.5707963267948966;
            if (startAngle > Math.PI * 2) {
                startAngle -= Math.PI * 2;
            }
            int neighboursCount = 0;
            int min1 = 1000;
            int min2 = 1000;
            int max = -1;
            int min1Id = -1;
            int min2Id = -2;
            int maxId = -3;
            HashMap<Integer, Integer> tmp = new HashMap<Integer, Integer>();
            while (iter.hasNext()) {
                currentNeighbour = iter.next();
                if (this.posSet[currentNeighbour] || tmp.containsKey(currentNeighbour)) continue;
                ++neighboursCount;
                tmp.put(currentNeighbour, 0);
                if (this.nodeHeights.get(currentNeighbour) < min1) {
                    min2 = min1;
                    min2Id = min1Id;
                    min1 = this.nodeHeights.get(currentNeighbour);
                    min1Id = currentNeighbour;
                } else if (this.nodeHeights.get(currentNeighbour) < min2) {
                    min2 = this.nodeHeights.get(currentNeighbour);
                    min2Id = currentNeighbour;
                }
                if (this.nodeHeights.get(currentNeighbour) < max) continue;
                max = this.nodeHeights.get(currentNeighbour);
                maxId = currentNeighbour;
            }
            if (neighboursCount == 0) {
                return;
            }
            double deltaAngle = Math.PI / (double)(neighboursCount + 1);
            if ((startAngle -= deltaAngle) < 0.0) {
                startAngle += Math.PI * 2;
            }
            double remStartAngle = startAngle;
            if (neighboursCount > 2) {
                deltaAngle = Math.PI * 2 / (double)neighboursCount;
                startAngle = theAngle + Math.PI - 3.0 * deltaAngle / 2.0;
                if (startAngle > Math.PI * 2) {
                    startAngle -= Math.PI * 2;
                }
                if ((remStartAngle = theAngle + Math.PI - deltaAngle / 2.0) > Math.PI * 2) {
                    remStartAngle -= Math.PI * 2;
                }
            }
            iter = this.edgesFrom[nodeID].iterator();
            double r = 72.0;
            if ((double)(48 * neighboursCount) / (Math.PI * 2) > r) {
                r = (double)(48 * neighboursCount) / (Math.PI * 2);
            }
            double rTry = r;
            double hlp = 100.0;
            double startX = (Double)this.nodeViews.get(nodeID).getVisualProperty(BasicVisualLexicon.NODE_X_LOCATION);
            double startY = (Double)this.nodeViews.get(nodeID).getVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION);
            if (neighboursCount > 2) {
                this.setOffset(this.nodeViews.get(nodeID), startX + Math.cos(theAngle) * r * (double)((min2 + 1) % 100), startY - Math.sin(theAngle) * r * (double)((min2 + 1) % 100));
                startX = (Double)this.nodeViews.get(nodeID).getVisualProperty(BasicVisualLexicon.NODE_X_LOCATION);
                startY = (Double)this.nodeViews.get(nodeID).getVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION);
                this.setOffset(this.nodeViews.get(min1Id), startX + Math.cos(remStartAngle) * r, startY - Math.sin(remStartAngle) * r);
                this.setOffset(this.nodeViews.get(min2Id), startX + Math.cos(remStartAngle + deltaAngle) * r, startY - Math.sin(remStartAngle + deltaAngle) * r);
                if (this.nodeHeights.get(maxId) > 8) {
                    r = 256.0;
                }
                this.setOffset(this.nodeViews.get(maxId), startX + Math.cos(remStartAngle - (double)(neighboursCount / 2) * deltaAngle) * r, startY - Math.sin(remStartAngle - (double)(neighboursCount / 2) * deltaAngle) * r);
            }
            tmp = new HashMap();
            while (iter.hasNext()) {
                currentNeighbour = iter.next();
                if (this.posSet[currentNeighbour] || tmp.containsKey(currentNeighbour)) continue;
                r = this.nodeHeights.get(currentNeighbour) > 8 ? 256.0 : rTry;
                this.posSet[currentNeighbour] = true;
                tmp.put(currentNeighbour, 0);
                if ((currentNeighbour == min1Id || currentNeighbour == min2Id || currentNeighbour == maxId) && neighboursCount > 2) continue;
                this.setOffset(this.nodeViews.get(currentNeighbour), startX + Math.cos(startAngle) * r, startY - Math.sin(startAngle) * r);
                startAngle -= deltaAngle;
                if (startAngle < 0.0) {
                    startAngle += Math.PI * 2;
                }
                if (!(Math.abs(startAngle - (remStartAngle - (double)(neighboursCount / 2) * deltaAngle)) < 1.0E-4) && !(Math.abs(startAngle - (remStartAngle - (double)(neighboursCount / 2) * deltaAngle + Math.PI * 2)) < 1.0E-4) || neighboursCount <= 2 || !((startAngle -= deltaAngle) < 0.0)) continue;
                startAngle += Math.PI * 2;
            }
            iter = this.edgesFrom[nodeID].iterator();
            if (neighboursCount > 2) {
                this.DFSSetPos(min1Id, remStartAngle, theRadius * Math.sin(deltaAngle / 2.0));
                this.DFSSetPos(min2Id, remStartAngle + deltaAngle, theRadius * Math.sin(deltaAngle / 2.0));
                this.DFSSetPos(maxId, remStartAngle - (double)(neighboursCount / 2) * deltaAngle, theRadius * Math.sin(deltaAngle / 2.0));
                hlp = remStartAngle;
                remStartAngle -= deltaAngle;
            }
            while (iter.hasNext()) {
                currentNeighbour = iter.next();
                if (!tmp.containsKey(currentNeighbour) || (currentNeighbour == min1Id || currentNeighbour == min2Id || currentNeighbour == maxId) && neighboursCount > 2) continue;
                this.DFSSetPos(currentNeighbour, remStartAngle, theRadius * Math.sin(deltaAngle / 2.0));
                if (((remStartAngle -= deltaAngle) == hlp - (double)(neighboursCount / 2) * deltaAngle || remStartAngle == hlp - (double)(neighboursCount / 2) * deltaAngle + Math.PI * 2) && neighboursCount > 2) {
                    startAngle -= deltaAngle;
                }
                if (!(remStartAngle < 0.0)) continue;
                remStartAngle += Math.PI * 2;
            }
        }
    }

    private int EachNodeHeight(int nodeID) {
        Iterator<Integer> iter = this.edgesFrom[nodeID].iterator();
        int noOfChildren = 0;
        HashMap<Integer, Integer> tmp = new HashMap<Integer, Integer>();
        while (iter.hasNext()) {
            int currentNeighbour = iter.next();
            if (this.depthPosSet[currentNeighbour] || tmp.containsKey(currentNeighbour)) continue;
            this.depthPosSet[currentNeighbour] = true;
            tmp.put(currentNeighbour, 0);
        }
        for (int currentNeighbour : this.edgesFrom[nodeID]) {
            if (!tmp.containsKey(currentNeighbour)) continue;
            noOfChildren += this.EachNodeHeight(currentNeighbour);
        }
        if (this.nodeHeights.containsKey(nodeID)) {
            this.nodeHeights.remove(nodeID);
        }
        this.nodeHeights.put(nodeID, noOfChildren);
        return noOfChildren + 1;
    }

    private int BestFreePositionsForAll(int idealPosition, int[] outerPositionsTaken, int[] outerPositionsOwners, int noOfPos, int innerCirclePos, double startX, double startY, double outerDeltaAngle, double outerRadius, int innerCSize) {
        int startPos = idealPosition;
        if (idealPosition < 0) {
            startPos += outerPositionsTaken.length;
        }
        int i = 0;
        int alreadyFound = 0;
        int startOfAlFound = -1;
        boolean found = false;
        boolean goDown = false;
        boolean goUp = false;
        int goUpCount = 0;
        int biggestGap = 0;
        int bestStartPos = 0;
        while (!(found || goUp && goDown)) {
            for (i = startPos; i < startPos + noOfPos && outerPositionsTaken[i % outerPositionsTaken.length] == -1; ++i) {
            }
            if (i < startPos + noOfPos) {
                if (outerPositionsTaken[i % outerPositionsTaken.length] > innerCirclePos && (double)(outerPositionsTaken[i % outerPositionsTaken.length] - innerCirclePos) < 0.7 * (double)innerCSize || (double)(innerCirclePos - outerPositionsTaken[i % outerPositionsTaken.length]) > 0.7 * (double)innerCSize) {
                    alreadyFound = (i - startPos + outerPositionsTaken.length) % outerPositionsTaken.length;
                    startOfAlFound = startPos;
                    if ((startPos -= noOfPos - alreadyFound) < 0) {
                        startPos += outerPositionsTaken.length;
                    }
                    goDown = true;
                    continue;
                }
                ++goUpCount;
                int thisGap = i - startPos;
                if (thisGap > biggestGap) {
                    biggestGap = thisGap;
                    bestStartPos = startPos;
                }
                if (goUpCount > outerPositionsTaken.length * 3) {
                    startPos = bestStartPos;
                    found = true;
                    continue;
                }
                startPos = (i + 1) % outerPositionsTaken.length;
                goUp = true;
                continue;
            }
            found = true;
        }
        if (goUp && goDown) {
            i = startOfAlFound - 1;
            int j = i - 1;
            int count = 0;
            int index = (i % outerPositionsTaken.length + outerPositionsTaken.length) % outerPositionsTaken.length;
            if (outerPositionsTaken[index] > innerCirclePos && (double)(outerPositionsTaken[index] - innerCirclePos) < 0.7 * (double)innerCSize || (double)(innerCirclePos - outerPositionsTaken[index]) > 0.7 * (double)innerCSize) {
                --j;
                --i;
            }
            while (count < noOfPos - alreadyFound) {
                if (outerPositionsTaken[(j + outerPositionsTaken.length) % outerPositionsTaken.length] == -1) {
                    if (outerPositionsOwners[(j + outerPositionsTaken.length) % outerPositionsTaken.length] == -2) {
                        return -1;
                    }
                    for (int k = j; k < i - count; ++k) {
                        if (outerPositionsOwners[(k + 1 + outerPositionsTaken.length) % outerPositionsTaken.length] > 0) {
                            this.setOffset(this.nodeViews.get(outerPositionsOwners[(k + 1 + outerPositionsTaken.length) % outerPositionsTaken.length]), startX + Math.cos(outerDeltaAngle * (double)k) * outerRadius, startY - Math.sin(outerDeltaAngle * (double)k) * outerRadius);
                        }
                        outerPositionsOwners[(k + outerPositionsTaken.length) % outerPositionsTaken.length] = outerPositionsOwners[(k + 1 + outerPositionsTaken.length) % outerPositionsTaken.length];
                        outerPositionsTaken[(k + outerPositionsTaken.length) % outerPositionsTaken.length] = outerPositionsTaken[(k + 1 + outerPositionsTaken.length) % outerPositionsTaken.length];
                    }
                    ++count;
                }
                --j;
            }
            startPos = (i - count + 1 + outerPositionsOwners.length) % outerPositionsOwners.length;
        }
        return startPos;
    }

    private void setOffset(View<CyNode> nv, double x, double y) {
        nv.setVisualProperty(BasicVisualLexicon.NODE_X_LOCATION, (Object)x);
        nv.setVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION, (Object)y);
    }
}

