/*
 * Decompiled with CFR 0.152.
 */
package csapps.layout.algorithms;

import csapps.layout.algorithms.GroupAttributesLayoutContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;
import org.cytoscape.view.layout.AbstractLayoutTask;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.undo.UndoSupport;

public class GroupAttributesLayoutTask
extends AbstractLayoutTask {
    private TaskMonitor taskMonitor;
    private CyNetwork network;
    private GroupAttributesLayoutContext context;

    public GroupAttributesLayoutTask(String displayName, CyNetworkView networkView, Set<View<CyNode>> nodesToLayOut, GroupAttributesLayoutContext context, String attrName, UndoSupport undo) {
        super(displayName, networkView, nodesToLayOut, attrName, undo);
        this.context = context;
    }

    protected final void doLayout(TaskMonitor taskMonitor) {
        this.taskMonitor = taskMonitor;
        this.network = (CyNetwork)this.networkView.getModel();
        this.construct();
    }

    private void construct() {
        this.taskMonitor.setStatusMessage("Initializing");
        CyTable dataTable = this.network.getDefaultNodeTable();
        Class klass = this.layoutAttribute == null || this.layoutAttribute.isEmpty() ? null : dataTable.getColumn(this.layoutAttribute).getType();
        if (klass == null || Comparable.class.isAssignableFrom(klass)) {
            Class kasted = klass;
            this.doConstruct(kasted);
        }
    }

    private <T extends Comparable<T>> void doConstruct(Class<T> klass) {
        TreeMap partitionMap = new TreeMap();
        ArrayList<CyNode> invalidNodes = new ArrayList<CyNode>();
        this.makeDiscrete(partitionMap, invalidNodes, klass);
        List<List<CyNode>> partitionList = this.sort(partitionMap);
        partitionList.add(invalidNodes);
        double offsetx = 0.0;
        double offsety = 0.0;
        double maxheight = 0.0;
        for (List<CyNode> partition : partitionList) {
            if (this.cancelled) {
                return;
            }
            double radius = this.encircle(partition, offsetx, offsety);
            double diameter = 2.0 * radius;
            if (diameter > maxheight) {
                maxheight = diameter;
            }
            if ((offsetx += diameter) > this.context.maxwidth) {
                offsety += maxheight + this.context.spacingy;
                offsetx = 0.0;
                maxheight = 0.0;
                continue;
            }
            offsetx += this.context.spacingx;
        }
    }

    private <T extends Comparable<T>> void makeDiscrete(Map<T, List<CyNode>> map, List<CyNode> invalidNodes, Class<T> klass) {
        if (klass == null) {
            for (View nv : this.nodesToLayOut) {
                CyNode node = (CyNode)nv.getModel();
                invalidNodes.add(node);
            }
        } else {
            for (View nv : this.nodesToLayOut) {
                CyNode node = (CyNode)nv.getModel();
                Comparable key = (Comparable)this.network.getRow((CyIdentifiable)node).get(this.layoutAttribute, klass);
                if (key == null) {
                    if (invalidNodes == null) continue;
                    invalidNodes.add(node);
                    continue;
                }
                List<CyNode> list = map.get(key);
                if (list == null) {
                    list = new ArrayList<CyNode>();
                    map.put(key, list);
                }
                list.add(node);
            }
        }
    }

    private <T extends Comparable<T>> List<List<CyNode>> sort(Map<T, List<CyNode>> map) {
        ArrayList<T> keys = new ArrayList<T>(map.keySet());
        Collections.sort(keys);
        Comparator<CyNode> comparator = new Comparator<CyNode>(){

            @Override
            public int compare(CyNode node1, CyNode node2) {
                Long a = node1.getSUID();
                Long b = node2.getSUID();
                return a.compareTo(b);
            }
        };
        ArrayList<List<CyNode>> sortedlist = new ArrayList<List<CyNode>>(map.keySet().size());
        for (Comparable key : keys) {
            List<CyNode> partition = map.get(key);
            Collections.sort(partition, comparator);
            sortedlist.add(partition);
        }
        return sortedlist;
    }

    private double encircle(List<CyNode> partition, double offsetx, double offsety) {
        if (partition == null) {
            return 0.0;
        }
        if (partition.size() == 1) {
            CyNode node = partition.get(0);
            this.networkView.getNodeView(node).setVisualProperty(BasicVisualLexicon.NODE_X_LOCATION, (Object)offsetx);
            this.networkView.getNodeView(node).setVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION, (Object)offsety);
            return 0.0;
        }
        double radius = this.context.radmult * Math.sqrt(partition.size());
        if (radius < this.context.minrad) {
            radius = this.context.minrad;
        }
        double phidelta = Math.PI * 2 / (double)partition.size();
        double phi = 0.0;
        for (CyNode node : partition) {
            double x = offsetx + radius + radius * Math.cos(phi);
            double y = offsety + radius + radius * Math.sin(phi);
            this.networkView.getNodeView(node).setVisualProperty(BasicVisualLexicon.NODE_X_LOCATION, (Object)x);
            this.networkView.getNodeView(node).setVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION, (Object)y);
            phi += phidelta;
        }
        return radius;
    }
}

