/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.group.internal.view;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.cytoscape.group.CyGroup;
import org.cytoscape.group.CyGroupManager;
import org.cytoscape.group.CyGroupSettingsManager;
import org.cytoscape.group.internal.CyGroupManagerImpl;
import org.cytoscape.group.internal.ModelUtils;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.presentation.RenderingEngine;
import org.cytoscape.view.presentation.RenderingEngineManager;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.view.presentation.property.NodeShapeVisualProperty;
import org.cytoscape.view.presentation.property.values.NodeShape;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyle;

public class ViewUtils {
    private static final VisualProperty<Double> xLoc = BasicVisualLexicon.NODE_X_LOCATION;
    private static final VisualProperty<Double> yLoc = BasicVisualLexicon.NODE_Y_LOCATION;
    private static final VisualProperty<Double> zLoc = BasicVisualLexicon.NODE_Z_LOCATION;
    private static final String X_LOCATION_ATTR = "__xLocation";
    private static final String Y_LOCATION_ATTR = "__yLocation";
    private static final String NETWORK_SUID_ATTR = "__groupNetworks.SUID";
    private static final String ISMEMBER_EDGE_ATTR = "__isMemberEdge";
    private static final double Z_OFFSET = -100.0;
    private static final int COMPOUND_NODE_TRANSPARENCY = 50;

    public static void applyStyle(Collection<? extends CyIdentifiable> elements, Collection<CyNetworkView> networkViews, VisualMappingManager cyStyleManager) {
        if (elements == null || networkViews == null) {
            return;
        }
        for (CyNetworkView netView : networkViews) {
            CyNetwork net = (CyNetwork)netView.getModel();
            VisualStyle style = cyStyleManager.getVisualStyle(netView);
            for (CyIdentifiable cyIdentifiable : elements) {
                View view = null;
                if (cyIdentifiable instanceof CyNode) {
                    view = netView.getNodeView((CyNode)cyIdentifiable);
                } else if (cyIdentifiable instanceof CyEdge) {
                    view = netView.getEdgeView((CyEdge)cyIdentifiable);
                }
                if (view == null) continue;
                style.apply(net.getRow(cyIdentifiable), view);
            }
        }
    }

    public static void styleCompoundNode(CyGroup group, CyNetworkView view, CyGroupManager groupManager, VisualMappingManager cyStyleManager, CyGroupSettingsManager.GroupViewType viewType) {
        double z = -100.0;
        if (viewType.equals((Object)CyGroupSettingsManager.GroupViewType.SINGLENODE)) {
            z = 100.0;
        }
        ArrayList<CyGroup> restyleList = new ArrayList<CyGroup>();
        for (CyNode node : group.getNodeList()) {
            View nv;
            if (!groupManager.isGroup(node, (CyNetwork)view.getModel()) || (nv = view.getNodeView(node)) == null) continue;
            z = (Double)nv.getVisualProperty(BasicVisualLexicon.NODE_Z_LOCATION) + -100.0;
            restyleList.add(groupManager.getGroup(node, (CyNetwork)view.getModel()));
        }
        View groupView = view.getNodeView(group.getGroupNode());
        VisualLexicon lex = ViewUtils.getVisualLexicon((CyGroupManagerImpl)groupManager, view);
        VisualProperty paddingProperty = lex.lookup(CyNode.class, "COMPOUND_NODE_PADDING");
        double padding = 5.0;
        if (paddingProperty != null) {
            padding = (Double)groupView.getVisualProperty(paddingProperty);
        }
        VisualProperty shapeProperty = lex.lookup(CyNode.class, "COMPOUND_NODE_SHAPE");
        NodeShape shape = NodeShapeVisualProperty.ROUND_RECTANGLE;
        if (shapeProperty != null) {
            shape = (NodeShape)groupView.getVisualProperty(shapeProperty);
        }
        if (groupView != null) {
            Rectangle2D bounds = ViewUtils.calculateBounds(group.getNodeList(), view, padding);
            double height = bounds.getHeight();
            double width = bounds.getWidth();
            double xLocation = bounds.getX() + width / 2.0;
            double yLocation = bounds.getY() + height / 2.0;
            if (shape.equals(NodeShapeVisualProperty.ELLIPSE) || shape.equals(NodeShapeVisualProperty.HEXAGON) || shape.equals(NodeShapeVisualProperty.OCTAGON)) {
                height *= Math.sqrt(1.5);
                width *= Math.sqrt(1.5);
            } else if (shape.equals(NodeShapeVisualProperty.DIAMOND)) {
                height *= Math.sqrt(2.0);
                width *= Math.sqrt(2.0);
            }
            groupView.setVisualProperty(xLoc, (Object)xLocation);
            groupView.setVisualProperty(yLoc, (Object)yLocation);
            groupView.setLockedValue(BasicVisualLexicon.NODE_HEIGHT, (Object)height);
            groupView.setLockedValue(BasicVisualLexicon.NODE_WIDTH, (Object)width);
            if (!viewType.equals((Object)CyGroupSettingsManager.GroupViewType.SINGLENODE)) {
                groupView.setLockedValue(BasicVisualLexicon.NODE_SHAPE, (Object)shape);
                groupView.setLockedValue(BasicVisualLexicon.NODE_TRANSPARENCY, (Object)50);
            } else {
                groupView.setLockedValue(BasicVisualLexicon.NODE_TRANSPARENCY, (Object)10);
                groupView.setLockedValue(BasicVisualLexicon.NODE_SHAPE, (Object)NodeShapeVisualProperty.RECTANGLE);
                groupView.setLockedValue(BasicVisualLexicon.NODE_BORDER_WIDTH, (Object)1.0);
                groupView.setLockedValue(BasicVisualLexicon.NODE_SELECTED_PAINT, (Object)new Color(255, 255, 0, 100));
            }
            groupView.setLockedValue(BasicVisualLexicon.NODE_Z_LOCATION, (Object)z);
            ViewUtils.updateGroupLocation((CyNetwork)view.getModel(), group, xLocation, yLocation);
        }
    }

    public static void unStyleCompoundNode(CyGroup group, CyNetworkView view, VisualMappingManager cyStyleManager) {
        View groupView = view.getNodeView(group.getGroupNode());
        if (groupView != null) {
            groupView.clearValueLock(BasicVisualLexicon.NODE_HEIGHT);
            groupView.clearValueLock(BasicVisualLexicon.NODE_WIDTH);
            groupView.clearValueLock(BasicVisualLexicon.NODE_TRANSPARENCY);
            groupView.clearValueLock(BasicVisualLexicon.NODE_SHAPE);
            groupView.clearValueLock(BasicVisualLexicon.NODE_BORDER_WIDTH);
            groupView.clearValueLock(BasicVisualLexicon.NODE_Z_LOCATION);
        }
        cyStyleManager.getVisualStyle(view).apply(((CyNetwork)view.getModel()).getRow((CyIdentifiable)group.getGroupNode()), groupView);
    }

    public static Dimension calculateCenter(CyNetworkView view, List<CyNode> nodeList) {
        double xCenter = 0.0;
        double yCenter = 0.0;
        CyNetwork network = (CyNetwork)view.getModel();
        int size = 0;
        for (CyNode node : nodeList) {
            View nView;
            if (!network.containsNode(node) || (nView = view.getNodeView(node)) == null) continue;
            ++size;
            xCenter += ((Double)nView.getVisualProperty(xLoc)).doubleValue();
            yCenter += ((Double)nView.getVisualProperty(yLoc)).doubleValue();
        }
        return ViewUtils.getDim(xCenter / (double)size, yCenter / (double)size);
    }

    public static void moveNodes(CyGroup group, CyNetworkView view, Dimension center) {
        CyNetwork net = (CyNetwork)view.getModel();
        for (CyNode node : group.getNodeList()) {
            if (!net.containsNode(node)) continue;
            Dimension location = ViewUtils.getOffsetLocation(net, group, node, center);
            ViewUtils.moveNode(view, node, location);
        }
    }

    public static Dimension calculateOffset(Dimension center, CyNetworkView view, CyNode node) {
        View nView = view.getNodeView(node);
        double xOffset = (Double)nView.getVisualProperty(xLoc) - center.getWidth();
        double yOffset = (Double)nView.getVisualProperty(yLoc) - center.getHeight();
        return ViewUtils.getDim(xOffset, yOffset);
    }

    public static Dimension getLocation(CyNetwork network, CyGroup group) {
        CyNetwork groupNetwork = group.getGroupNetwork();
        CyTable netTable = groupNetwork.getTable(CyNetwork.class, "HIDDEN");
        Dimension dim = ViewUtils.getNodeLocation(netTable, network, groupNetwork.getSUID());
        return dim;
    }

    public static Dimension getOffsetLocation(CyNetwork network, CyGroup group, CyNode node, Dimension center) {
        CyTable nodeTable = group.getGroupNetwork().getTable(CyNode.class, "HIDDEN");
        Dimension d = ViewUtils.getNodeLocation(nodeTable, network, node.getSUID());
        if (d != null && center != null) {
            d.setSize(d.getWidth() + center.getWidth(), d.getHeight() + center.getHeight());
        }
        return d;
    }

    public static void updateNodeOffset(CyNetwork network, CyGroup group, CyNode node, Dimension offset) {
        CyTable nodeTable = group.getGroupNetwork().getTable(CyNode.class, "HIDDEN");
        ViewUtils.updateNodeLocation(nodeTable, network, node.getSUID(), offset);
    }

    public static void updateGroupLocation(CyNetwork network, CyGroup group, double x, double y) {
        Dimension offset = ViewUtils.getDim(x, y);
        ViewUtils.updateGroupLocation(network, group, offset);
    }

    public static void updateGroupLocation(CyNetwork network, CyGroup group, Dimension offset) {
        CyNetwork groupNetwork = group.getGroupNetwork();
        CyTable netTable = groupNetwork.getTable(CyNetwork.class, "HIDDEN");
        ViewUtils.updateNodeLocation(netTable, network, groupNetwork.getSUID(), offset);
    }

    public static void moveNode(CyNetworkView view, CyNode node, Dimension location) {
        View nView = view.getNodeView(node);
        nView.setVisualProperty(xLoc, (Object)location.getWidth());
        nView.setVisualProperty(yLoc, (Object)location.getHeight());
    }

    public static void updateNodeLocation(CyTable table, CyNetwork network, Long suid, Dimension location) {
        ModelUtils.createListColumnIfNeeded(table, NETWORK_SUID_ATTR, Long.class);
        ModelUtils.createListColumnIfNeeded(table, X_LOCATION_ATTR, Double.class);
        ModelUtils.createListColumnIfNeeded(table, Y_LOCATION_ATTR, Double.class);
        CyRow row = table.getRow((Object)suid);
        List<Long> networkSUIDs = ModelUtils.getList(row, NETWORK_SUID_ATTR, Long.class);
        List<Double> xLocations = ModelUtils.getList(row, X_LOCATION_ATTR, Double.class);
        List<Double> yLocations = ModelUtils.getList(row, Y_LOCATION_ATTR, Double.class);
        int index = networkSUIDs.indexOf(network.getSUID());
        if (index == -1) {
            networkSUIDs.add(network.getSUID());
            xLocations.add(location.getWidth());
            yLocations.add(location.getHeight());
        } else {
            xLocations.set(index, location.getWidth());
            yLocations.set(index, location.getHeight());
        }
        row.set(NETWORK_SUID_ATTR, networkSUIDs);
        row.set(X_LOCATION_ATTR, xLocations);
        row.set(Y_LOCATION_ATTR, yLocations);
    }

    public static Dimension getNodeLocation(CyTable table, CyNetwork network, Long suid) {
        if (!table.rowExists((Object)suid)) {
            return null;
        }
        CyRow row = table.getRow((Object)suid);
        List<Long> networkSUIDs = ModelUtils.getList(row, NETWORK_SUID_ATTR, Long.class);
        List<Double> xLocations = ModelUtils.getList(row, X_LOCATION_ATTR, Double.class);
        List<Double> yLocations = ModelUtils.getList(row, Y_LOCATION_ATTR, Double.class);
        int index = networkSUIDs.indexOf(network.getSUID());
        if (index >= 0) {
            return ViewUtils.getDim(xLocations.get(index), yLocations.get(index));
        }
        if (xLocations.size() > 0) {
            return ViewUtils.getDim(xLocations.get(0), yLocations.get(0));
        }
        return null;
    }

    public static void copyNodeLocations(CyGroup group, CyNetworkView source, CyNetworkView dest) {
        for (CyNode node : group.getNodeList()) {
            View nodeView = source.getNodeView(node);
            View nNodeView = dest.getNodeView(node);
            dest.setVisualProperty(xLoc, (Object)((Double)source.getVisualProperty(xLoc)));
            dest.setVisualProperty(yLoc, (Object)((Double)source.getVisualProperty(yLoc)));
            dest.setVisualProperty(zLoc, (Object)((Double)source.getVisualProperty(zLoc)));
        }
    }

    public static Dimension getDim(double x, double y) {
        Dimension d = new Dimension();
        d.setSize(x, y);
        return d;
    }

    public static Rectangle2D calculateBounds(List<CyNode> nodes, CyNetworkView view, double padding) {
        double x1 = Double.POSITIVE_INFINITY;
        double y1 = Double.POSITIVE_INFINITY;
        double x2 = Double.NEGATIVE_INFINITY;
        double y2 = Double.NEGATIVE_INFINITY;
        for (CyNode node : nodes) {
            View nv = view.getNodeView(node);
            if (nv == null) continue;
            double nw = (Double)nv.getVisualProperty(BasicVisualLexicon.NODE_WIDTH);
            double nh = (Double)nv.getVisualProperty(BasicVisualLexicon.NODE_HEIGHT);
            double nx = (Double)nv.getVisualProperty(xLoc) - nw / 2.0;
            double ny = (Double)nv.getVisualProperty(yLoc) - nh / 2.0;
            x1 = Math.min(x1, nx);
            y1 = Math.min(y1, ny);
            x2 = Math.max(x2, nx + nw);
            y2 = Math.max(y2, ny + nh);
        }
        return new Rectangle2D.Double(x1 - padding, y1 - padding, x2 - x1 + padding * 2.0, y2 - y1 + padding * 2.0);
    }

    public static VisualLexicon getVisualLexicon(CyGroupManagerImpl groupMgr, CyNetworkView netView) {
        RenderingEngineManager rendererMgr = groupMgr.getService(RenderingEngineManager.class);
        Collection renderingEngines = rendererMgr.getRenderingEngines((View)netView);
        if (renderingEngines != null && !renderingEngines.isEmpty()) {
            return ((RenderingEngine)renderingEngines.iterator().next()).getVisualLexicon();
        }
        return rendererMgr.getDefaultVisualLexicon();
    }
}

