/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.group.internal.data.aggregators;

import java.util.HashMap;
import java.util.HashSet;
import org.cytoscape.group.CyGroup;
import org.cytoscape.group.data.Aggregator;
import org.cytoscape.group.data.AttributeHandlingType;
import org.cytoscape.group.data.CyGroupAggregationManager;
import org.cytoscape.group.internal.data.aggregators.AbstractAggregator;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyTable;

public class StringAggregator
extends AbstractAggregator {
    static AttributeHandlingType[] supportedTypes = new AttributeHandlingType[]{AttributeHandlingType.NONE, AttributeHandlingType.CSV, AttributeHandlingType.TSV, AttributeHandlingType.MCV, AttributeHandlingType.UNIQUE};
    static boolean registered = false;

    public static void registerAggregators(CyGroupAggregationManager mgr) {
        if (!registered) {
            for (AttributeHandlingType t : supportedTypes) {
                mgr.addAggregator((Aggregator)new StringAggregator(t));
            }
        }
        registered = true;
    }

    public StringAggregator(AttributeHandlingType type) {
        this.type = type;
    }

    public Class getSupportedType() {
        return String.class;
    }

    public String aggregate(CyTable table, CyGroup group, CyColumn column) {
        Object aggregation = null;
        HashMap<String, Integer> histo = null;
        HashSet<String> unique = null;
        if (this.type == AttributeHandlingType.NONE) {
            return null;
        }
        for (Object node : group.getNodeList()) {
            String value = (String)table.getRow((Object)node.getSUID()).get(column.getName(), String.class);
            if (value == null) continue;
            switch (this.type) {
                case CSV: {
                    if (aggregation == null) {
                        aggregation = value;
                        break;
                    }
                    aggregation = (String)aggregation + "," + value;
                    break;
                }
                case TSV: {
                    if (aggregation == null) {
                        aggregation = value;
                        break;
                    }
                    aggregation = (String)aggregation + "\t" + value;
                    break;
                }
                case MCV: {
                    if (histo == null) {
                        histo = new HashMap<String, Integer>();
                    }
                    if (histo.containsKey(value)) {
                        histo.put(value, (Integer)histo.get(value) + 1);
                        break;
                    }
                    histo.put(value, 1);
                    break;
                }
                case UNIQUE: {
                    if (unique == null) {
                        unique = new HashSet<String>();
                    }
                    unique.add(value);
                }
            }
        }
        if (this.type == AttributeHandlingType.MCV) {
            int maxValue = -1;
            for (String key : histo.keySet()) {
                int count = (Integer)histo.get(key);
                if (count <= maxValue) continue;
                aggregation = key;
                maxValue = count;
            }
            if (aggregation == null) {
                aggregation = "";
            }
        } else if (this.type == AttributeHandlingType.UNIQUE) {
            for (String value : unique) {
                if (aggregation == null) {
                    aggregation = value;
                    continue;
                }
                aggregation = (String)aggregation + "," + value;
            }
        }
        table.getRow((Object)group.getGroupNode().getSUID()).set(column.getName(), aggregation);
        return aggregation;
    }
}

