/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.group.internal.data.aggregators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.cytoscape.group.CyGroup;
import org.cytoscape.group.data.Aggregator;
import org.cytoscape.group.data.AttributeHandlingType;
import org.cytoscape.group.data.CyGroupAggregationManager;
import org.cytoscape.group.internal.data.aggregators.AbstractAggregator;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;

public class IntegerListAggregator
extends AbstractAggregator<List<Integer>> {
    static AttributeHandlingType[] supportedTypes = new AttributeHandlingType[]{AttributeHandlingType.NONE, AttributeHandlingType.AVG, AttributeHandlingType.MIN, AttributeHandlingType.MAX, AttributeHandlingType.MEDIAN, AttributeHandlingType.SUM, AttributeHandlingType.CONCAT, AttributeHandlingType.UNIQUE};
    static boolean registered = false;

    public static void registerAggregators(CyGroupAggregationManager mgr) {
        if (!registered) {
            for (AttributeHandlingType t : supportedTypes) {
                mgr.addAggregator((Aggregator)new IntegerListAggregator(t));
            }
        }
        registered = true;
    }

    public IntegerListAggregator(AttributeHandlingType type) {
        this.type = type;
    }

    public Class<?> getSupportedType() {
        return List.class;
    }

    public Class<?> getSupportedListType() {
        return Integer.class;
    }

    @Override
    public List<Integer> aggregate(CyTable table, CyGroup group, CyColumn column) {
        Class listType = column.getListElementType();
        ArrayList<Integer> agg = new ArrayList<Integer>();
        ArrayList aggMed = new ArrayList();
        HashSet<Integer> aggset = new HashSet<Integer>();
        ArrayList<Integer> aggregation = null;
        if (this.type == AttributeHandlingType.NONE) {
            return null;
        }
        if (!listType.equals(Integer.class)) {
            return null;
        }
        int nodeCount = 0;
        for (CyNode cyNode : group.getNodeList()) {
            List list = table.getRow((Object)cyNode.getSUID()).getList(column.getName(), listType);
            if (list == null) continue;
            int index = 0;
            ++nodeCount;
            for (Object obj : list) {
                Integer value = (Integer)obj;
                switch (this.type) {
                    case CONCAT: {
                        agg.add(value);
                        break;
                    }
                    case UNIQUE: {
                        aggset.add(value);
                        break;
                    }
                    case AVG: 
                    case SUM: {
                        if (agg.size() > index) {
                            value = value + (Integer)agg.get(index);
                            agg.set(index, value);
                            break;
                        }
                        agg.add(index, value);
                        break;
                    }
                    case MIN: {
                        if (agg.size() > index) {
                            value = Math.min(value, (Integer)agg.get(index));
                            agg.set(index, value);
                            break;
                        }
                        agg.add(index, value);
                        break;
                    }
                    case MAX: {
                        if (agg.size() > index) {
                            value = Math.max(value, (Integer)agg.get(index));
                            agg.set(index, value);
                            break;
                        }
                        agg.add(index, value);
                        break;
                    }
                    case MEDIAN: {
                        if (aggMed.size() > index) {
                            ((List)aggMed.get(index)).add(value);
                            break;
                        }
                        ArrayList<Integer> l = new ArrayList<Integer>();
                        l.add(value);
                        aggMed.add(index, l);
                    }
                }
                ++index;
            }
        }
        if (this.type == AttributeHandlingType.UNIQUE) {
            aggregation = new ArrayList<Integer>(aggset);
        } else if (this.type == AttributeHandlingType.AVG) {
            aggregation = new ArrayList();
            for (Integer n : agg) {
                aggregation.add(Math.round((float)n.intValue() / (float)nodeCount));
            }
        } else if (this.type == AttributeHandlingType.MEDIAN) {
            aggregation = new ArrayList();
            for (List list : aggMed) {
                Object[] vArray = new Integer[list.size()];
                vArray = list.toArray(vArray);
                Arrays.sort(vArray);
                if (vArray.length % 2 == 1) {
                    aggregation.add((Integer)vArray[(vArray.length - 1) / 2]);
                    continue;
                }
                aggregation.add(((Integer)vArray[vArray.length / 2 - 1] + (Integer)vArray[vArray.length / 2]) / 2);
            }
        } else {
            aggregation = agg;
        }
        if (aggregation != null) {
            table.getRow((Object)group.getGroupNode().getSUID()).set(column.getName(), aggregation);
        }
        return aggregation;
    }
}

