/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.group.internal.data.aggregators;

import org.cytoscape.group.CyGroup;
import org.cytoscape.group.data.Aggregator;
import org.cytoscape.group.data.AttributeHandlingType;
import org.cytoscape.group.data.CyGroupAggregationManager;
import org.cytoscape.group.internal.data.aggregators.AbstractAggregator;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;

public class BooleanAggregator
extends AbstractAggregator {
    static AttributeHandlingType[] supportedTypes = new AttributeHandlingType[]{AttributeHandlingType.NONE, AttributeHandlingType.AND, AttributeHandlingType.OR};
    static boolean registered = false;

    public static void registerAggregators(CyGroupAggregationManager mgr) {
        if (!registered) {
            for (AttributeHandlingType t : supportedTypes) {
                mgr.addAggregator((Aggregator)new BooleanAggregator(t));
            }
        }
        registered = true;
    }

    public BooleanAggregator(AttributeHandlingType type) {
        this.type = type;
    }

    public Class getSupportedType() {
        return Boolean.class;
    }

    public Boolean aggregate(CyTable table, CyGroup group, CyColumn column) {
        if (this.type == AttributeHandlingType.NONE) {
            return null;
        }
        boolean aggregation = false;
        boolean first = true;
        for (CyNode node : group.getNodeList()) {
            Boolean v = (Boolean)table.getRow((Object)node.getSUID()).get(column.getName(), Boolean.class);
            if (v == null) continue;
            boolean value = v;
            if (first) {
                aggregation = value;
                first = false;
                continue;
            }
            switch (this.type) {
                case AND: {
                    aggregation &= value;
                    break;
                }
                case OR: {
                    aggregation |= value;
                }
            }
        }
        Boolean v = new Boolean(aggregation);
        table.getRow((Object)group.getGroupNode().getSUID()).set(column.getName(), (Object)v);
        return v;
    }
}

