/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.group.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cytoscape.event.CyEvent;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.group.CyGroup;
import org.cytoscape.group.CyGroupManager;
import org.cytoscape.group.events.GroupAboutToBeDestroyedEvent;
import org.cytoscape.group.events.GroupAddedEvent;
import org.cytoscape.group.internal.CyGroupImpl;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.events.AboutToRemoveEdgesEvent;
import org.cytoscape.model.events.AboutToRemoveEdgesListener;
import org.cytoscape.model.events.AddedEdgesEvent;
import org.cytoscape.model.events.AddedEdgesListener;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;

public class CyGroupManagerImpl
implements CyGroupManager,
AddedEdgesListener,
AboutToRemoveEdgesListener {
    private final CyServiceRegistrar cyServiceRegistrar;
    private Set<CyGroup> groupSet;
    private Map<CyRootNetwork, Set<CyGroup>> rootMap;
    private static final String GROUP_LIST_ATTRIBUTE = "__groupList.SUID";
    private final Object lock = new Object();

    public CyGroupManagerImpl(CyServiceRegistrar cyServiceRegistrar) {
        this.groupSet = new HashSet<CyGroup>();
        this.rootMap = new HashMap<CyRootNetwork, Set<CyGroup>>();
        this.cyServiceRegistrar = cyServiceRegistrar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<CyGroup> getGroupSet(CyNetwork network) {
        Object object = this.lock;
        synchronized (object) {
            HashSet<CyGroup> groupNetSet = new HashSet<CyGroup>();
            for (CyGroup group : this.groupSet) {
                if (!group.isInNetwork(network)) continue;
                groupNetSet.add(group);
            }
            return groupNetSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGroup(CyGroup group) {
        Object object = this.lock;
        synchronized (object) {
            if (this.groupSet.contains(group)) {
                return;
            }
            this.groupSet.add(group);
            this.addGroupToRootMap(group);
        }
        CyEventHelper cyEventHelper = this.getService(CyEventHelper.class);
        cyEventHelper.fireEvent((CyEvent)new GroupAddedEvent((CyGroupManager)this, group));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGroups(List<CyGroup> groups) {
        Object object = this.lock;
        synchronized (object) {
            for (CyGroup group : groups) {
                if (this.groupSet.contains(group)) continue;
                this.groupSet.add(group);
                this.addGroupToRootMap(group);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CyGroup> getGroupsForNode(CyNode node) {
        Object object = this.lock;
        synchronized (object) {
            ArrayList<CyGroup> returnList = new ArrayList<CyGroup>();
            for (CyGroup group : this.groupSet) {
                if (!group.getGroupNetwork().containsNode(node)) continue;
                returnList.add(group);
            }
            return returnList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CyGroup> getGroupsForNode(CyNode node, CyNetwork network) {
        Object object = this.lock;
        synchronized (object) {
            ArrayList<CyGroup> returnList = new ArrayList<CyGroup>();
            for (CyGroup group : this.groupSet) {
                if (!group.isInNetwork(network) || !group.getGroupNetwork().containsNode(node)) continue;
                returnList.add(group);
            }
            return returnList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CyGroup getGroup(CyNode node, CyNetwork network) {
        Object object = this.lock;
        synchronized (object) {
            for (CyGroup group : this.groupSet) {
                if (!group.isInNetwork(network) || !group.getGroupNode().equals(node)) continue;
                return group;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isGroup(CyNode node, CyNetwork network) {
        Object object = this.lock;
        synchronized (object) {
            for (CyGroup group : this.groupSet) {
                if (!group.isInNetwork(network) || !group.getGroupNode().equals(node)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyGroup(CyGroup group) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.groupSet.contains(group)) {
                return;
            }
        }
        CyEventHelper cyEventHelper = this.getService(CyEventHelper.class);
        cyEventHelper.fireEvent((CyEvent)new GroupAboutToBeDestroyedEvent((CyGroupManager)this, group));
        Object object2 = this.lock;
        synchronized (object2) {
            if (this.rootMap.containsKey(group.getRootNetwork())) {
                this.rootMap.get(group.getRootNetwork()).remove(group);
            }
            this.groupSet.remove(group);
        }
        ((CyGroupImpl)group).destroyGroup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.lock;
        synchronized (object) {
            this.groupSet = new HashSet<CyGroup>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<CyGroup> getAllGroups() {
        Object object = this.lock;
        synchronized (object) {
            return Collections.unmodifiableSet(this.groupSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<CyGroup> getGroupSet(CyRootNetwork root) {
        Object object = this.lock;
        synchronized (object) {
            return this.rootMap.get(root);
        }
    }

    public List<Long> getGroupAttribute(CyRootNetwork rootNet) {
        CyRow rhRow = rootNet.getRow((CyIdentifiable)rootNet, "HIDDEN");
        if (rhRow.getTable().getColumn(GROUP_LIST_ATTRIBUTE) == null) {
            return null;
        }
        return rhRow.getList(GROUP_LIST_ATTRIBUTE, Long.class);
    }

    public <S> S getService(Class<S> serviceClass) {
        return (S)this.cyServiceRegistrar.getService(serviceClass);
    }

    public <S> S getService(Class<S> serviceClass, String search) {
        return (S)this.cyServiceRegistrar.getService(serviceClass, search);
    }

    public void handleEvent(AddedEdgesEvent addedEdgesEvent) {
        CyNetwork net = (CyNetwork)addedEdgesEvent.getSource();
        Collection edges = addedEdgesEvent.getPayloadCollection();
        Set<CyGroup> groups = this.getGroupSet(net);
        if (groups == null || groups.size() == 0) {
            return;
        }
        for (CyGroup group : groups) {
            CyGroupImpl gImpl = (CyGroupImpl)group;
            if (!gImpl.isCollapsing() && !gImpl.isExpanding()) continue;
            return;
        }
        ArrayList<CyEdge> edgesToAdd = new ArrayList<CyEdge>();
        for (CyGroup group : groups) {
            CyGroupImpl gImpl = (CyGroupImpl)group;
            for (CyEdge edge : edges) {
                if (gImpl.isMeta(edge) || !gImpl.isConnectingEdge(edge)) continue;
                edgesToAdd.add(edge);
            }
            group.addEdges(edgesToAdd);
        }
    }

    public void handleEvent(AboutToRemoveEdgesEvent removedEdgesEvent) {
        CyNetwork net = (CyNetwork)removedEdgesEvent.getSource();
        Collection edges = removedEdgesEvent.getEdges();
        Set<CyGroup> groups = this.getGroupSet(net);
        if (groups == null || groups.size() == 0) {
            return;
        }
        for (CyGroup group : groups) {
            CyGroupImpl gImpl = (CyGroupImpl)group;
            if (!gImpl.isCollapsing() && !gImpl.isExpanding()) continue;
            return;
        }
        ArrayList<CyEdge> edgesToRemove = new ArrayList<CyEdge>();
        for (CyGroup group : groups) {
            for (CyEdge edge : edges) {
                edgesToRemove.add(edge);
            }
            group.removeEdges(edgesToRemove);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addGroupToRootMap(CyGroup group) {
        Object object = this.lock;
        synchronized (object) {
            if (this.rootMap.containsKey(group.getRootNetwork())) {
                this.rootMap.get(group.getRootNetwork()).add(group);
            } else {
                HashSet<CyGroup> groupNetSet = new HashSet<CyGroup>();
                groupNetSet.add(group);
                this.rootMap.put(group.getRootNetwork(), groupNetSet);
            }
        }
    }

    private void updateGroupAttribute(CyGroup group) {
        CyRootNetwork rootNet = group.getRootNetwork();
        CyRow rhRow = rootNet.getRow((CyIdentifiable)rootNet, "HIDDEN");
        if (rhRow.getTable().getColumn(GROUP_LIST_ATTRIBUTE) == null) {
            rhRow.getTable().createListColumn(GROUP_LIST_ATTRIBUTE, Long.class, false);
        }
        ArrayList<Long> groupSUIDs = new ArrayList<Long>();
        for (CyGroup g : this.getGroupSet(rootNet)) {
            groupSUIDs.add(g.getGroupNode().getSUID());
        }
        rhRow.set(GROUP_LIST_ATTRIBUTE, groupSUIDs);
    }
}

