/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.vizmap;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.vizmap.LoadVizmapFileTask;
import org.cytoscape.task.read.LoadVizmapFileTaskFactory;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.work.AbstractTaskFactory;
import org.cytoscape.work.SynchronousTaskManager;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskObserver;
import org.cytoscape.work.TunableSetter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadVizmapFileTaskFactoryImpl
extends AbstractTaskFactory
implements LoadVizmapFileTaskFactory {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private final CyServiceRegistrar serviceRegistrar;

    public LoadVizmapFileTaskFactoryImpl(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
    }

    public TaskIterator createTaskIterator() {
        return new TaskIterator(2, new Task[]{this.createTask()});
    }

    public LoadVizmapFileTask createTask() {
        return new LoadVizmapFileTask(this.serviceRegistrar);
    }

    public Set<VisualStyle> loadStyles(File f) {
        HashMap<String, File> m = new HashMap<String, File>();
        m.put("file", f);
        LoadVizmapFileTask task = this.createTask();
        SynchronousTaskManager syncTaskManager = (SynchronousTaskManager)this.serviceRegistrar.getService(SynchronousTaskManager.class);
        syncTaskManager.setExecutionContext(m);
        syncTaskManager.execute(new TaskIterator(2, new Task[]{task}));
        return task.getStyles();
    }

    public Set<VisualStyle> loadStyles(InputStream is) {
        File f = null;
        try {
            f = this.getFileFromStream(is);
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not create temp file", e);
        }
        if (f == null) {
            throw new NullPointerException("Could not create temp file.");
        }
        return this.loadStyles(f);
    }

    public TaskIterator createTaskIterator(File file) {
        return this.createTaskIterator(file, null);
    }

    public TaskIterator createTaskIterator(File file, TaskObserver observer) {
        HashMap<String, File> m = new HashMap<String, File>();
        m.put("file", file);
        TunableSetter tunableSetter = (TunableSetter)this.serviceRegistrar.getService(TunableSetter.class);
        return tunableSetter.createTaskIterator(this.createTaskIterator(), m, observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getFileFromStream(InputStream is) throws IOException {
        File returnFile = null;
        ArrayList<String> list = new ArrayList<String>();
        BufferedReader bf = null;
        try {
            String line;
            bf = new BufferedReader(new InputStreamReader(is));
            while (null != (line = bf.readLine())) {
                list.add(line);
            }
        }
        catch (IOException e) {
            logger.error("Could not read the VizMap file.", (Throwable)e);
        }
        finally {
            try {
                if (bf != null) {
                    bf.close();
                }
            }
            catch (IOException e) {
                logger.error("Could not Close the stream.", (Throwable)e);
                bf = null;
            }
        }
        if (list.size() == 0) {
            return null;
        }
        Writer output = null;
        try {
            returnFile = File.createTempFile("visualStyles", "", new File(System.getProperty("java.io.tmpdir")));
            returnFile.deleteOnExit();
            output = new BufferedWriter(new FileWriter(returnFile));
            for (int i = 0; i < list.size(); ++i) {
                output.write((String)list.get(i) + "\n");
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                    output = null;
                }
                catch (IOException e) {
                    logger.error("Could not close stream.", (Throwable)e);
                    output = null;
                }
            }
        }
        if (returnFile == null) {
            throw new NullPointerException("Could not create temp VizMap file.");
        }
        String originalFileName = returnFile.getAbsolutePath();
        if (this.isXML(list)) {
            File xmlFile = new File(originalFileName + ".xml");
            boolean renamed = returnFile.renameTo(xmlFile);
            if (renamed) {
                return xmlFile;
            }
            throw new IOException("Could not create temp vizmap file: " + xmlFile);
        }
        File propFile = new File(originalFileName + ".props");
        boolean renamed = returnFile.renameTo(propFile);
        if (renamed) {
            return propFile;
        }
        throw new IOException("Could not create temp vizmap file: " + propFile);
    }

    private final boolean isXML(List<String> list) {
        if (list == null || list.isEmpty()) {
            return false;
        }
        return list.get(0).contains("<?xml");
    }
}

