/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.vizmap;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.cytoscape.io.read.VizmapReader;
import org.cytoscape.io.read.VizmapReaderManager;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.json.JSONResult;

public class LoadVizmapFileTask
extends AbstractTask {
    @Tunable(description="Styles File:", longDescription="XML or properties file where one or more styles have been saved to.", exampleStringValue="/Users/johndoe/Downloads/MyStyles.xml", required=true, params="fileCategory=vizmap;input=true")
    public File file;
    private AddVisualStylesTask addStyleTask;
    private final CyServiceRegistrar serviceRegistrar;

    @ProvidesTitle
    public String getTitle() {
        return "Import Style";
    }

    public LoadVizmapFileTask(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        taskMonitor.setProgress(0.0);
        taskMonitor.setTitle("Load Styles from File");
        taskMonitor.setStatusMessage("Looking for a reader...");
        if (this.file == null) {
            throw new NullPointerException("No file specified.");
        }
        VizmapReaderManager readerManager = (VizmapReaderManager)this.serviceRegistrar.getService(VizmapReaderManager.class);
        VizmapReader reader = readerManager.getReader(this.file.toURI(), this.file.getName());
        taskMonitor.setProgress(0.9);
        if (reader == null) {
            throw new NullPointerException("Failed to find appropriate reader for file: " + this.file);
        }
        this.addStyleTask = new AddVisualStylesTask(reader);
        this.insertTasksAfterCurrentTask(new Task[]{reader, this.addStyleTask});
        taskMonitor.setProgress(1.0);
    }

    public Set<VisualStyle> getStyles() {
        return this.addStyleTask.getStyles();
    }

    private class AddVisualStylesTask
    extends AbstractTask
    implements ObservableTask {
        private final VizmapReader reader;
        private Set<VisualStyle> styles;

        public AddVisualStylesTask(VizmapReader reader) {
            this.reader = reader;
        }

        public void run(TaskMonitor taskMonitor) throws Exception {
            taskMonitor.setProgress(0.0);
            taskMonitor.setTitle("Add Styles");
            taskMonitor.setStatusMessage("Adding styles...");
            this.styles = this.reader.getVisualStyles();
            if (this.styles != null) {
                int count = 1;
                int total = this.styles.size();
                VisualMappingManager vmManager = (VisualMappingManager)LoadVizmapFileTask.this.serviceRegistrar.getService(VisualMappingManager.class);
                for (VisualStyle vs : this.styles) {
                    if (this.cancelled) break;
                    taskMonitor.setStatusMessage(count + " of " + total + ": " + vs.getTitle());
                    vmManager.addVisualStyle(vs);
                    taskMonitor.setProgress((double)(count / total));
                    ++count;
                }
                if (this.cancelled) {
                    for (VisualStyle vs : this.styles) {
                        vmManager.removeVisualStyle(vs);
                    }
                }
            }
            taskMonitor.setProgress(1.0);
        }

        public Object getResults(Class type) {
            if (type == List.class || type == Collection.class) {
                return this.styles != null ? new ArrayList<VisualStyle>(this.styles) : Collections.emptyList();
            }
            if (type == String.class) {
                Object res = "";
                if (this.styles != null && !this.styles.isEmpty()) {
                    res = (String)res + "Loaded styles:\n";
                    for (VisualStyle style : this.styles) {
                        res = (String)res + style.toString() + "\n";
                    }
                    res = ((String)res).substring(0, ((String)res).length() - 1);
                } else {
                    res = "No styles were loaded.";
                }
                return res;
            }
            if (type == JSONResult.class) {
                JsonArray jsonArr = new JsonArray();
                if (this.styles != null && !this.styles.isEmpty()) {
                    for (VisualStyle vs : this.styles) {
                        jsonArr.add((JsonElement)new JsonPrimitive(vs.getTitle()));
                    }
                }
                String json = new Gson().toJson((JsonElement)jsonArr);
                JSONResult res = () -> json;
                return res;
            }
            return this.styles;
        }

        public List<Class<?>> getResultClasses() {
            return Arrays.asList(String.class, List.class, JSONResult.class);
        }

        public Set<VisualStyle> getStyles() {
            return this.styles;
        }
    }
}

