/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyTable;
import org.cytoscape.task.internal.utils.DataUtils;
import org.cytoscape.work.Tunable;

public class ColumnValueTunable {
    @Tunable(description="Namespace for table", context="nogui", longDescription="Node, Edge, and Network objects support the ```default```, ```local```, and ```hidden``` namespaces. Root networks also support the ```shared``` namespace. Custom namespaces may be specified by Apps.", exampleStringValue="default")
    public String namespace = "default";
    @Tunable(description="List of columns to set", context="nogui", longDescription="A list of column names, separated by commas.", exampleStringValue="name,Column B")
    public String columnList;
    @Tunable(description="List of values", context="nogui", longDescription="A list of values, separated by commas. For values of type list, use the format ```[value1,value2]```.", exampleStringValue="New Name,2")
    public String valueList;

    public String getNamespace() {
        return this.namespace;
    }

    public List<CyColumn> getColumnList(CyTable table) {
        if (table == null) {
            return null;
        }
        if (this.columnList == null || this.columnList.equalsIgnoreCase("all")) {
            return new ArrayList<CyColumn>(table.getColumns());
        }
        String[] columns = this.columnList.split(",");
        ArrayList<CyColumn> returnValue = new ArrayList<CyColumn>();
        for (String column : columns) {
            CyColumn c = table.getColumn(column);
            if (c == null) continue;
            returnValue.add(c);
        }
        return returnValue;
    }

    public List<String> getColumnNames(CyTable table) {
        if (table == null) {
            return null;
        }
        ArrayList<String> resultString = new ArrayList<String>();
        for (CyColumn column : this.getColumnList(table)) {
            resultString.add(column.getName());
        }
        return resultString;
    }

    public Map<CyColumn, Object> getValueMap(CyTable table) {
        if (table == null) {
            return null;
        }
        HashMap<CyColumn, Object> returnValues = new HashMap<CyColumn, Object>();
        List<String> values = this.parseValues(this.valueList);
        int index = 0;
        for (CyColumn column : this.getColumnList(table)) {
            String value = values.get(index);
            Class type = column.getType();
            returnValues.put(column, this.getValue(value, type, column));
            ++index;
        }
        return returnValues;
    }

    private Object getValue(String value, Class type, CyColumn column) {
        if (value.length() == 0) {
            return null;
        }
        if (type.equals(List.class)) {
            Class elementType = column.getListElementType();
            String[] values = value.split(",");
            ArrayList<Object> vList = new ArrayList<Object>();
            for (String v : values) {
                vList.add(this.getValue(v, elementType, column));
            }
            return vList;
        }
        if (type.equals(String.class)) {
            return value;
        }
        if (type.equals(Integer.class)) {
            return Integer.valueOf(value);
        }
        if (type.equals(Long.class)) {
            return Long.valueOf(value);
        }
        if (type.equals(Double.class)) {
            return Double.valueOf(value);
        }
        if (type.equals(Boolean.class)) {
            return Boolean.valueOf(value);
        }
        return null;
    }

    private List<String> parseValues(String values) {
        String[] v1;
        ArrayList<String> vList = new ArrayList<String>();
        boolean inList = false;
        Object listString = "";
        for (String v : v1 = DataUtils.getCSV(values)) {
            v = v.trim();
            if (inList) {
                listString = (String)listString + "," + v;
                if (!v.endsWith("]")) continue;
                vList.add(((String)listString).substring(0, ((String)listString).length() - 1));
                inList = false;
                continue;
            }
            if (v.startsWith("[")) {
                inList = true;
                listString = v.substring(1);
                continue;
            }
            vList.add(v);
        }
        return vList;
    }
}

