/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.title;

import java.util.Arrays;
import java.util.List;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.session.CyNetworkNaming;
import org.cytoscape.task.AbstractNetworkTask;
import org.cytoscape.task.internal.title.NetworkTitleEdit;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.TunableValidator;
import org.cytoscape.work.json.JSONResult;
import org.cytoscape.work.undo.AbstractCyEdit;
import org.cytoscape.work.undo.UndoSupport;

public class EditNetworkTitleTask
extends AbstractNetworkTask
implements TunableValidator,
ObservableTask {
    @Tunable(description="New title for network", longDescription="Enter a new title for the network", exampleStringValue="My network name", required=true)
    public String name;
    @Tunable(description="Network to rename", longDescription="Specifies a network by name, or by SUID if the prefix ```SUID:``` is used. The keyword ```CURRENT```, or a blank value can also be used to specify the current network.", exampleStringValue="current", required=true, context="nogui")
    public CyNetwork sourceNetwork;
    private final CyServiceRegistrar serviceRegistrar;

    @ProvidesTitle
    public String getTitle() {
        return "Rename Network";
    }

    public EditNetworkTitleTask(CyNetwork net, CyServiceRegistrar serviceRegistrar) {
        super(net);
        this.serviceRegistrar = serviceRegistrar;
        this.name = (String)this.network.getRow((CyIdentifiable)this.network).get("name", String.class);
    }

    public TunableValidator.ValidationState getValidationState(Appendable errMsg) {
        this.name = this.name.trim();
        boolean titleAlreayExisted = false;
        String newTitle = ((CyNetworkNaming)this.serviceRegistrar.getService(CyNetworkNaming.class)).getSuggestedNetworkTitle(this.name);
        if (!newTitle.equalsIgnoreCase(this.name)) {
            titleAlreayExisted = true;
        }
        if (titleAlreayExisted) {
            try {
                errMsg.append("Duplicated network name.");
            }
            catch (Exception e) {
                System.out.println("Warning: Duplicated network name.");
            }
            return TunableValidator.ValidationState.INVALID;
        }
        return TunableValidator.ValidationState.OK;
    }

    public void run(TaskMonitor e) {
        e.setProgress(0.0);
        if (this.sourceNetwork == null) {
            this.sourceNetwork = this.network;
        }
        String oldTitle = (String)this.network.getRow((CyIdentifiable)this.sourceNetwork).get("name", String.class);
        e.setProgress(0.3);
        this.network.getRow((CyIdentifiable)this.sourceNetwork).set("name", (Object)this.name);
        e.setProgress(0.6);
        ((UndoSupport)this.serviceRegistrar.getService(UndoSupport.class)).postEdit((AbstractCyEdit)new NetworkTitleEdit(this.sourceNetwork, oldTitle));
        e.setProgress(1.0);
    }

    public Object getResults(Class type) {
        if (type.equals(CyNetwork.class)) {
            return this.sourceNetwork;
        }
        if (type.equals(String.class)) {
            if (this.sourceNetwork == null) {
                return "<none>";
            }
            return "Network " + this.sourceNetwork.getSUID() + " renamed to " + this.name;
        }
        if (type.equals(JSONResult.class)) {
            JSONResult res = () -> {
                if (this.sourceNetwork == null) {
                    return "{}";
                }
                return "{\"network\":" + this.sourceNetwork.getSUID() + ", \"title\":\"" + this.name + "\"}";
            };
            return res;
        }
        return this.sourceNetwork;
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(CyNetwork.class, String.class, JSONResult.class);
    }
}

