/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringJoiner;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.table.AbstractTableDataTask;
import org.cytoscape.task.internal.utils.DataUtils;
import org.cytoscape.task.internal.utils.RowTunable;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.json.JSONResult;

public class SetValuesTask
extends AbstractTableDataTask
implements ObservableTask {
    private CyTable table;
    private List<String> rowKeys;
    @ContainsTunables
    public RowTunable rowTunable;
    @Tunable(description="Column to set", context="nogui", longDescription="Specifies the name of a column in the table", exampleStringValue="Property")
    public String columnName;
    @Tunable(description="Value to set", context="nogui", longDescription="The value to set the columns in the selected rows to.  This should be a string value, which will be converted to the appropriate column type.", exampleStringValue="BRCA")
    public String value;

    public SetValuesTask(CyServiceRegistrar serviceRegistrar) {
        super(serviceRegistrar);
        this.rowTunable = new RowTunable(serviceRegistrar);
    }

    public void run(TaskMonitor tm) {
        this.table = this.rowTunable.getTable();
        if (this.table == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Unable to find table '" + this.rowTunable.getTableString() + "'");
            return;
        }
        List<CyRow> rowList = this.rowTunable.getRowList();
        if (rowList == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "No rows returned");
            return;
        }
        if (this.columnName == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "No column specified");
            return;
        }
        if (this.value == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "No values specified");
            return;
        }
        CyColumn column = this.table.getColumn(this.columnName);
        if (column == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Column '" + this.columnName + "' doesn't exist in this table");
            return;
        }
        Class columnType = column.getType();
        Class listType = null;
        if (columnType.equals(List.class)) {
            listType = column.getListElementType();
        }
        String primaryKey = this.table.getPrimaryKey().getName();
        CyColumn nameColumn = this.table.getColumn("name");
        String nameKey = null;
        if (nameColumn != null) {
            nameKey = nameColumn.getName();
        }
        tm.showMessage(TaskMonitor.Level.INFO, "Retreived " + rowList.size() + " rows:");
        this.rowKeys = new ArrayList<String>();
        for (CyRow row : rowList) {
            String key = row.getRaw(primaryKey).toString();
            String message = "  Row (key:" + key;
            message = nameKey != null ? message + ", name: " + (String)row.get(nameKey, String.class) + ") " : message + ") ";
            if (listType == null) {
                try {
                    row.set(column.getName(), DataUtils.convertString(this.value, columnType));
                }
                catch (NumberFormatException nfe) {
                    tm.showMessage(TaskMonitor.Level.ERROR, "Unable to convert " + this.value + " to a " + DataUtils.getType(columnType));
                    return;
                }
                message = message + "column " + column.getName() + " set to " + DataUtils.convertString(this.value, columnType).toString();
            } else {
                try {
                    row.set(column.getName(), DataUtils.convertStringList(this.value, listType));
                }
                catch (NumberFormatException nfe) {
                    tm.showMessage(TaskMonitor.Level.ERROR, "Unable to convert " + this.value + " to a list of " + DataUtils.getType(listType) + "s");
                    return;
                }
                message = message + "list column " + column.getName() + " set to " + DataUtils.convertStringList(this.value, listType).toString();
            }
            this.rowKeys.add(key);
            tm.showMessage(TaskMonitor.Level.INFO, message);
        }
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(List.class, String.class, JSONResult.class);
    }

    public Object getResults(Class requestedType) {
        if (requestedType.equals(String.class)) {
            Object ret = "";
            for (String key : this.rowKeys) {
                ret = (String)ret + key + ",";
            }
            return ((String)ret).substring(0, ((String)ret).length() - 1);
        }
        if (requestedType.equals(JSONResult.class)) {
            JSONResult res = () -> {
                if (this.table == null || this.rowTunable.getRowList() == null) {
                    return "{}";
                }
                String xstring = "{\"table\":" + this.table.getSUID() + ",\"rows\": ";
                StringJoiner joiner = new StringJoiner(", ", "[", "]");
                for (String key : this.rowKeys) {
                    joiner.add("\"" + key + "\"");
                }
                return xstring.substring(0, xstring.length() - 1) + joiner.toString() + "}";
            };
            return res;
        }
        return this.rowKeys;
    }
}

