/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.table;

import java.util.Arrays;
import java.util.List;
import org.cytoscape.model.CyTable;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.table.AbstractTableDataTask;
import org.cytoscape.task.internal.utils.TableTunable;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.json.JSONResult;

public class SetTableTitleTask
extends AbstractTableDataTask
implements ObservableTask {
    private CyTable table;
    @ContainsTunables
    public TableTunable tableTunable;
    @Tunable(description="New table title", context="nogui", longDescription="The name of the table used in the current network", exampleStringValue="Filtered Edges")
    public String title;

    public SetTableTitleTask(CyServiceRegistrar serviceRegistrar) {
        super(serviceRegistrar);
        this.tableTunable = new TableTunable(serviceRegistrar);
    }

    public void run(TaskMonitor tm) {
        this.table = this.tableTunable.getTable();
        if (this.table == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Unable to find table '" + this.tableTunable.getTableString() + "'");
            return;
        }
        if (this.title == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "New title must be specified");
            return;
        }
        String oldTitle = this.table.getTitle();
        this.table.setTitle(this.title);
        tm.showMessage(TaskMonitor.Level.INFO, "Changed title of table '" + oldTitle + "' to '" + this.title + "'");
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(String.class, JSONResult.class);
    }

    public Object getResults(Class requestedType) {
        if (requestedType.equals(String.class)) {
            return this.title;
        }
        if (requestedType.equals(JSONResult.class)) {
            JSONResult res = () -> {
                if (this.table == null) {
                    return "{}";
                }
                return "{\"table\":" + this.table.getSUID() + ", \"title\":\"" + this.title + "\"}";
            };
            return res;
        }
        return null;
    }
}

