/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.table;

import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyTable;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.AbstractTableColumnTask;
import org.cytoscape.task.internal.table.RenameColumnEdit;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.TunableValidator;
import org.cytoscape.work.undo.AbstractCyEdit;
import org.cytoscape.work.undo.UndoSupport;

public final class RenameColumnTask
extends AbstractTableColumnTask
implements TunableValidator {
    @Tunable(description="New Column Name", required=true)
    public String newColumnName;
    private final CyServiceRegistrar serviceRegistrar;

    @ProvidesTitle
    public String getTitle() {
        return "Rename Column";
    }

    RenameColumnTask(CyColumn column, CyServiceRegistrar serviceRegistrar) {
        super(column);
        this.serviceRegistrar = serviceRegistrar;
        this.newColumnName = column.getName();
    }

    public void run(TaskMonitor tm) throws Exception {
        tm.setProgress(0.0);
        ((UndoSupport)this.serviceRegistrar.getService(UndoSupport.class)).postEdit((AbstractCyEdit)new RenameColumnEdit(this.column));
        tm.setProgress(0.4);
        this.column.setName(this.newColumnName);
        tm.setProgress(1.0);
    }

    public TunableValidator.ValidationState getValidationState(Appendable errMsg) {
        if (this.newColumnName == null) {
            try {
                errMsg.append("You must provide a new column name.");
            }
            catch (Exception exception) {
                // empty catch block
            }
            return TunableValidator.ValidationState.INVALID;
        }
        this.newColumnName = this.newColumnName.trim();
        if (this.newColumnName.isEmpty()) {
            try {
                errMsg.append("Column name must not be blank.");
            }
            catch (Exception exception) {
                // empty catch block
            }
            return TunableValidator.ValidationState.INVALID;
        }
        CyTable table = this.column.getTable();
        CyColumn foundColumn = table.getColumn(this.newColumnName);
        if (foundColumn != null && !foundColumn.equals(this.column)) {
            try {
                errMsg.append("Column name is a duplicate.");
            }
            catch (Exception exception) {
                // empty catch block
            }
            return TunableValidator.ValidationState.INVALID;
        }
        if (this.column.isImmutable()) {
            try {
                errMsg.append("Cannot rename an immutable column.");
            }
            catch (Exception exception) {
                // empty catch block
            }
            return TunableValidator.ValidationState.INVALID;
        }
        return TunableValidator.ValidationState.OK;
    }
}

