/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.table;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.cytoscape.io.read.CyTableReader;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CyRootNetworkManager;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.util.ListMultipleSelection;
import org.cytoscape.work.util.ListSingleSelection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MapTableToNetworkTablesTask
extends AbstractTask {
    private static Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private static String NO_NETWORKS = "No Networks Found";
    private final CyTable globalTable;
    private final CyTableReader reader;
    private final boolean byReader;
    private Map<String, CyNetwork> name2NetworkMap;
    private final CyServiceRegistrar serviceRegistrar;
    @Tunable(description="Import Data To:")
    public ListSingleSelection<TableType> dataTypeOptions;
    @Tunable(description="Apply to Selected Networks Only", groups={"Network Options"}, dependsOn="dataTypeOptions!=Unassigned Tables", params="displayState=collapsed")
    public boolean selectedNetworksOnly = false;
    @Tunable(description="Network List", groups={"Network Options"}, dependsOn="selectedNetworksOnly=true", params="displayState=collapsed")
    public ListMultipleSelection<String> networkList;

    @ProvidesTitle
    public String getTitle() {
        return "Import Data ";
    }

    public MapTableToNetworkTablesTask(CyTableReader reader, CyServiceRegistrar serviceRegistrar) {
        this.reader = reader;
        this.globalTable = null;
        this.byReader = true;
        this.name2NetworkMap = new HashMap<String, CyNetwork>();
        this.serviceRegistrar = serviceRegistrar;
        this.initTunable();
    }

    public MapTableToNetworkTablesTask(CyTable globalTable, CyServiceRegistrar serviceRegistrar) {
        this.globalTable = globalTable;
        this.byReader = false;
        this.reader = null;
        this.name2NetworkMap = new HashMap<String, CyNetwork>();
        this.serviceRegistrar = serviceRegistrar;
        this.initTunable();
    }

    private void initTunable() {
        ArrayList<TableType> options = new ArrayList<TableType>();
        for (TableType type : TableType.values()) {
            options.add(type);
        }
        this.dataTypeOptions = new ListSingleSelection(options);
        this.dataTypeOptions.setSelectedValue((Object)TableType.NODE_ATTR);
        CyNetworkManager netManager = (CyNetworkManager)this.serviceRegistrar.getService(CyNetworkManager.class);
        for (CyNetwork net : netManager.getNetworkSet()) {
            String netName = (String)net.getRow((CyIdentifiable)net).get("name", String.class);
            this.name2NetworkMap.put(netName, net);
        }
        ArrayList<String> names = new ArrayList<String>();
        names.addAll(this.name2NetworkMap.keySet());
        this.networkList = names.isEmpty() ? new ListMultipleSelection((Object[])new String[]{NO_NETWORKS}) : new ListMultipleSelection(names);
    }

    public void run(TaskMonitor tm) throws Exception {
        tm.setTitle("Map Table to Network Tables");
        TableType tableType = (TableType)((Object)this.dataTypeOptions.getSelectedValue());
        if (tableType == TableType.GLOBAL) {
            return;
        }
        if (!this.selectedNetworksOnly) {
            this.mapTableToDefaultAttrs(tableType);
        } else {
            this.mapTableToLocalAttrs(tableType);
        }
    }

    private void mapTableToLocalAttrs(TableType tableType) {
        ArrayList<CyNetwork> networks = new ArrayList<CyNetwork>();
        if (!((String)this.networkList.getSelectedValues().get(0)).equals(NO_NETWORKS)) {
            for (String netName : this.networkList.getSelectedValues()) {
                networks.add(this.name2NetworkMap.get(netName));
            }
        }
        for (CyNetwork network : networks) {
            CyTable targetTable = this.getTable(network, tableType, "LOCAL_ATTRS");
            if (targetTable == null) continue;
            this.applyMapping(targetTable);
        }
    }

    private void mapTableToDefaultAttrs(TableType tableType) {
        ArrayList<CyRootNetwork> rootNetworkList = new ArrayList<CyRootNetwork>();
        CyNetworkManager netManager = (CyNetworkManager)this.serviceRegistrar.getService(CyNetworkManager.class);
        CyRootNetworkManager rootNetManager = (CyRootNetworkManager)this.serviceRegistrar.getService(CyRootNetworkManager.class);
        for (CyNetwork net : netManager.getNetworkSet()) {
            if (rootNetworkList.contains(rootNetManager.getRootNetwork(net))) continue;
            rootNetworkList.add(rootNetManager.getRootNetwork(net));
        }
        for (CyRootNetwork root : rootNetworkList) {
            CyTable targetTable = this.getTable((CyNetwork)root, tableType, "USER");
            if (targetTable == null) continue;
            this.applyMapping(targetTable);
        }
    }

    private CyTable getTable(CyNetwork network, TableType tableType, String namespace) {
        if (tableType == TableType.NODE_ATTR) {
            return network.getTable(CyNode.class, namespace);
        }
        if (tableType == TableType.EDGE_ATTR) {
            return network.getTable(CyEdge.class, namespace);
        }
        if (tableType == TableType.NETWORK_ATTR) {
            return network.getTable(CyNetwork.class, namespace);
        }
        logger.warn("The selected table type is not valie. \nTable needs to be one of these types: " + TableType.NODE_ATTR + ", " + TableType.EDGE_ATTR + ", " + TableType.NETWORK_ATTR + " or " + TableType.GLOBAL + ".");
        return null;
    }

    private void applyMapping(CyTable targetTable) {
        if (this.byReader) {
            if (this.reader.getTables() != null && this.reader.getTables().length > 0) {
                for (CyTable sourceTable : this.reader.getTables()) {
                    this.mapTable(targetTable, sourceTable);
                }
            }
        } else {
            this.mapTable(targetTable, this.globalTable);
        }
    }

    private void mapTable(CyTable localTable, CyTable globalTable) {
        if (globalTable.getPrimaryKey().getType() != String.class) {
            throw new IllegalStateException("Local table's primary key should be type String.");
        }
        CyColumn trgCol = localTable.getColumn("shared name");
        if (trgCol != null) {
            localTable.addVirtualColumns(globalTable, "shared name", false);
            globalTable.setPublic(false);
        } else {
            logger.warn("Name column in the target table was not found.");
        }
    }

    static enum TableType {
        NODE_ATTR("Node Table", CyNode.class),
        EDGE_ATTR("Edge Table", CyEdge.class),
        NETWORK_ATTR("Network Table", CyNetwork.class),
        GLOBAL("Unassigned Tables", CyTable.class);

        private final String name;
        private final Class<? extends CyIdentifiable> type;

        private TableType(String name, Class<? extends CyIdentifiable> type) {
            this.name = name;
            this.type = type;
        }

        public Class<? extends CyIdentifiable> getType() {
            return this.type;
        }

        public String toString() {
            return this.name;
        }
    }
}

