/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.table;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableManager;
import org.cytoscape.task.AbstractTableTaskFactory;
import org.cytoscape.task.edit.MapGlobalToLocalTableTaskFactory;
import org.cytoscape.task.internal.table.MapGlobalToLocalTableTask;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TunableSetter;
import org.cytoscape.work.util.ListMultipleSelection;

public final class MapGlobalToLocalTableTaskFactoryImpl
extends AbstractTableTaskFactory
implements MapGlobalToLocalTableTaskFactory {
    private final CyTableManager tableManager;
    private final CyNetworkManager networkManager;
    private final TunableSetter tunableSetter;

    public MapGlobalToLocalTableTaskFactoryImpl(CyTableManager tableManager, CyNetworkManager networkManager, TunableSetter tunableSetter) {
        this.tableManager = tableManager;
        this.networkManager = networkManager;
        this.tunableSetter = tunableSetter;
    }

    public TaskIterator createTaskIterator(CyTable globalTable) {
        return new TaskIterator(new Task[]{new MapGlobalToLocalTableTask(globalTable, this.tableManager, this.networkManager)});
    }

    public TaskIterator createTaskIterator(CyTable globalTable, Collection<CyTable> localTables) {
        HashMap<String, ListMultipleSelection> m = new HashMap<String, ListMultipleSelection>();
        ArrayList<String> localTableTitles = new ArrayList<String>();
        for (CyTable local : localTables) {
            localTableTitles.add(local.getTitle());
        }
        ListMultipleSelection localTablesTunable = new ListMultipleSelection(localTableTitles);
        localTablesTunable.setSelectedValues(localTableTitles);
        m.put("localTables", localTablesTunable);
        return this.tunableSetter.createTaskIterator(this.createTaskIterator(globalTable), m);
    }
}

