/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.cytoscape.model.CyNetworkTableManager;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableManager;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.table.AbstractTableDataTask;
import org.cytoscape.task.internal.utils.DataUtils;
import org.cytoscape.util.json.CyJSONUtil;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.json.JSONResult;
import org.cytoscape.work.util.ListSingleSelection;

public class ListTablesTask
extends AbstractTableDataTask
implements ObservableTask {
    List<CyTable> tables;
    @Tunable(description="Type of table", context="nogui", longDescription="One of ''network'', ''node'', ''edge'', ''unattached'', ''all'', to constrain the type of table listed", exampleStringValue="all")
    public ListSingleSelection<String> type = new ListSingleSelection((Object[])new String[]{"network", "node", "edge", "unattached", "all"});
    @Tunable(description="Table namespace", context="nogui", longDescription="An optional argument to contrain output to a single namespace, or ALL", exampleStringValue="all")
    public String namespace = "default";
    @Tunable(description="Include private tables?", context="nogui", longDescription="A boolean value determining whether to return private as well as public tables", exampleStringValue="true")
    public boolean includePrivate = true;

    public ListTablesTask(CyServiceRegistrar serviceRegistrar) {
        super(serviceRegistrar);
        this.type.setSelectedValue((Object)"all");
    }

    public void run(TaskMonitor tm) {
        Set allTables = ((CyTableManager)this.serviceRegistrar.getService(CyTableManager.class)).getAllTables(this.includePrivate);
        this.tables = new ArrayList<CyTable>();
        String requestedType = (String)this.type.getSelectedValue();
        String requestedNamespace = this.getNamespace(this.namespace);
        CyNetworkTableManager networkTableMgr = (CyNetworkTableManager)this.serviceRegistrar.getService(CyNetworkTableManager.class);
        for (CyTable table : allTables) {
            String strClass;
            Class tableClass;
            if (!requestedType.equals("all") && ((tableClass = networkTableMgr.getTableType(table)) != null && !requestedType.equals("unattached") ? !(strClass = DataUtils.getIdentifiableType(tableClass)).equalsIgnoreCase(requestedType) || !requestedNamespace.equalsIgnoreCase(networkTableMgr.getTableNamespace(table)) : tableClass != null && requestedType.equals("unattached"))) continue;
            tm.showMessage(TaskMonitor.Level.INFO, "Table " + this.getTableDescription(table));
            this.tables.add(table);
        }
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(List.class, String.class, JSONResult.class);
    }

    public Object getResults(Class requestedType) {
        System.out.println(requestedType + "---------------");
        if (requestedType.equals(String.class)) {
            return DataUtils.convertData(this.tables);
        }
        if (requestedType.equals(JSONResult.class)) {
            JSONResult res = () -> {
                if (this.tables == null) {
                    return "{}";
                }
                CyJSONUtil cyJSONUtil = (CyJSONUtil)this.serviceRegistrar.getService(CyJSONUtil.class);
                return "{\"tables\":" + cyJSONUtil.cyIdentifiablesToJson(this.tables) + "}";
            };
            return res;
        }
        return null;
    }

    private String getTableDescription(CyTable table) {
        String result = "[" + table.getSUID() + "]";
        int rows = table.getRowCount();
        int cols = table.getColumns().size();
        result = table.isPublic() ? result + " is a public table with " : result + " is a private table with ";
        result = result + rows + " rows and " + cols + " columns with title:\n";
        result = result + "        " + table.getTitle();
        return result;
    }
}

