/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.table.AbstractTableDataTask;
import org.cytoscape.task.internal.utils.DataUtils;
import org.cytoscape.util.json.CyJSONUtil;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.json.JSONResult;

public class ListNodeAttributesTask
extends AbstractTableDataTask
implements ObservableTask {
    Collection<CyColumn> columnList;
    @Tunable(description="Network", context="nogui", longDescription="Specifies a network by name, or by SUID if the prefix ```SUID:``` is used. The keyword ```CURRENT```, or a blank value can also be used to specify the current network.", exampleStringValue="current")
    public CyNetwork network;
    @Tunable(description="Namespace for table", context="nogui", longDescription="Node, Edge, and Network objects support the ```default```, ```local```, and ```hidden``` namespaces. Root networks also support the ```shared``` namespace. Custom namespaces may be specified by Apps.", exampleStringValue="default")
    public String namespace = "default";

    public ListNodeAttributesTask(CyServiceRegistrar serviceRegistrar) {
        super(serviceRegistrar);
    }

    public void run(TaskMonitor tm) {
        if (this.network == null) {
            this.network = ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getCurrentNetwork();
            if (this.network == null) {
                tm.showMessage(TaskMonitor.Level.ERROR, "Network must be specified");
                throw new RuntimeException("Network must be specified");
            }
        }
        CyTable networkTable = this.getNetworkTable(this.network, CyNode.class, this.namespace);
        this.columnList = networkTable.getColumns();
        tm.showMessage(TaskMonitor.Level.INFO, "   Node columns for network " + DataUtils.getNetworkName(this.network) + ":");
        for (CyColumn column : this.columnList) {
            if (column.getType().equals(List.class)) {
                tm.showMessage(TaskMonitor.Level.INFO, "        " + column.getName() + ": " + DataUtils.getType(column.getListElementType()) + " list");
                continue;
            }
            tm.showMessage(TaskMonitor.Level.INFO, "        " + column.getName() + ": " + DataUtils.getType(column.getType()));
        }
    }

    public Object getResults(Class requestedType) {
        if (requestedType.equals(String.class)) {
            Object returnString = "[";
            for (CyColumn col : this.columnList) {
                returnString = (String)returnString + col.getName() + ",";
            }
            return ((String)returnString).substring(0, ((String)returnString).length() - 1) + "]";
        }
        if (requestedType.equals(JSONResult.class)) {
            JSONResult res = () -> {
                CyJSONUtil cyJSONUtil = (CyJSONUtil)this.serviceRegistrar.getService(CyJSONUtil.class);
                return cyJSONUtil.cyColumnsToJson(this.columnList);
            };
            return res;
        }
        return new ArrayList<CyColumn>(this.columnList);
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(List.class, String.class, JSONResult.class);
    }
}

